/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.inspections.CssConvertColorToRgbInspection;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class CssConvertColorToHexInspection
extends CssConvertColorToRgbInspection {
    private static final LocalQuickFix fix = new LocalQuickFix(){

        @NotNull
        public String getName() {
            String string = CssBundle.message("css.convert.color.value.to.hex", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.convert.color.to.hex.family", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement value;
            if (project == null) {
                1.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                1.$$$reportNull$$$0(3);
            }
            if ((value = descriptor.getPsiElement()) == null) {
                return;
            }
            Color color = CssPsiColorUtil.getColor(value);
            if (color != null) {
                Language language = CssPsiUtil.getStylesheetLanguage(value);
                value.replace((PsiElement)CssElementFactory.getInstance(project).createTerm(CssPsiColorUtil.toHexColor(color), language));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssConvertColorToHexInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    };

    @Override
    @NotNull
    public String getShortName() {
        return "CssConvertColorToHexInspection";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssConvertColorToHexInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssTerm(CssTerm _term) {
                super.visitCssTerm(_term);
                if (CssTermTypes.COLOR == _term.getTermType()) {
                    ColorDeclarationType type = ColorDeclarationType.fromColorTerm(_term);
                    Color color = CssPsiColorUtil.getColor(_term);
                    if (!(color == null || type == ColorDeclarationType.HEX || type.withAlphaChannel() && color.getAlpha() != 255)) {
                        holder.registerProblem((PsiElement)_term, CssBundle.message("css.convert.color.value.to.hex", new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{fix});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/CssConvertColorToHexInspection", "buildVisitor"));
    }
}

