/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.stylelint.StylelintBundle;
import com.intellij.stylelint.StylelintState;
import com.intellij.stylelint.StylelintViewContent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class StylelintView
extends JSLinterBaseView<StylelintState> {
    private final StylelintViewContent content;

    public StylelintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            StylelintView.$$$reportNull$$$0(0);
        }
        super(fullModeDialog);
        this.content = new StylelintViewContent(new NodePackageField(project, "stylelint", () -> NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()), StylelintView.createConfigFileField(project));
    }

    private static TextFieldWithBrowseButton createConfigFileField(@NotNull Project project) {
        TextFieldWithBrowseButton configFileField;
        JTextField textField;
        if (project == null) {
            StylelintView.$$$reportNull$$$0(1);
        }
        if ((textField = (configFileField = new TextFieldWithBrowseButton()).getTextField()) instanceof ComponentWithEmptyText) {
            ComponentWithEmptyText componentWithEmptyText = (ComponentWithEmptyText)textField;
            componentWithEmptyText.getEmptyText().setText(StylelintBundle.message("stylelint.settings.config.file.auto.detect", new Object[0]));
        }
        configFileField.addBrowseFolderListener(project, FileChooserDescriptorFactory.createSingleFileDescriptor().withShowHiddenFiles(true).withTitle(StylelintBundle.message("stylelint.select.config.file.title", new Object[0])));
        configFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String filePath;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(filePath = FileUtil.toSystemIndependentName((String)configFileField.getText().trim())).isEmpty()) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
                    if (file == null || file.isDirectory()) {
                        configFileField.getTextField().setForeground((Color)JBColor.RED);
                    } else {
                        configFileField.getTextField().setForeground(UIUtil.getTextFieldForeground());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/stylelint/StylelintView$1", "textChanged"));
            }
        });
        return configFileField;
    }

    @NotNull
    protected Component createCenterComponent() {
        DialogPanel dialogPanel = this.content.panel;
        if (dialogPanel == null) {
            StylelintView.$$$reportNull$$$0(2);
        }
        return dialogPanel;
    }

    @NotNull
    protected StylelintState getState() {
        return new StylelintState(this.content.stylelintPackageField.getSelected(), FileUtil.toSystemIndependentName((String)this.content.configFileField.getText().trim()), this.content.runForFilesField.getText().trim(), this.content.runOnSaveCheckBox.isSelected());
    }

    protected void setState(@NotNull StylelintState state) {
        if (state == null) {
            StylelintView.$$$reportNull$$$0(3);
        }
        this.content.stylelintPackageField.setSelected(state.getStylelintPackage());
        this.content.configFileField.setText(FileUtil.toSystemDependentName((String)state.getConfigFilePath()));
        this.content.runForFilesField.setText(state.getFilesPattern());
        this.content.runOnSaveCheckBox.setSelected(state.isRunOnSave());
        if (this.isFullModeDialog()) {
            this.content.stylelintPackageField.setPreferredWidthToFitText();
        }
    }

    public void setRunOnSaveCheckBoxSelected(boolean selected) {
        this.content.getRunOnSaveCheckBox().setSelected(selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfigFileField";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

