/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.diagram.settings.DiagramLayoutOnCategorySwitch;
import com.intellij.diagram.settings.DiagramNodeItemStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Arrays;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@State(name="UmlConfiguration", storages={@Storage(value="uml.xml")}, category=SettingsCategory.CODE)
public class DiagramConfiguration
implements PersistentStateComponent<DiagramConfiguration>,
Cloneable {
    @NotNull
    @NlsSafe
    public volatile String defaultScope = "All";
    @NotNull
    public volatile DiagramLayout layout = DiagramLayout.HIERARCHIC_COMPACT;
    public volatile boolean fitContentAfterLayout = true;
    public volatile boolean relayoutOnNewElements = true;
    @NotNull
    public volatile DiagramLayoutOnCategorySwitch myLayoutOnCategorySwitch = DiagramLayoutOnCategorySwitch.WITH_LIGHT_LAYOUTER;
    public volatile boolean myDoShowGridByDefault = true;
    public volatile boolean myDoNodeItemSyntaxHighlighting = true;
    public volatile boolean myIsAnimationsEnabled = true;
    public volatile int myShortenNodeItemOnLength = 60;
    public volatile int myLayoutAnimationDurationMillis = 1500;
    @NotNull
    public volatile DiagramNodeItemStyle myNodeItemStyle = DiagramNodeItemStyle.ALIGNED;
    @MapAnnotation(keyAttributeName="id", valueAttributeName="categories")
    public Map<String, String> categories = ConcurrentCollectionFactory.createConcurrentMap();

    @NotNull
    public static DiagramConfiguration getInstance() {
        DiagramConfiguration diagramConfiguration = (DiagramConfiguration)ApplicationManager.getApplication().getService(DiagramConfiguration.class);
        if (diagramConfiguration == null) {
            DiagramConfiguration.$$$reportNull$$$0(0);
        }
        return diagramConfiguration;
    }

    @NotNull
    public DiagramLayout getDefaultLayout() {
        DiagramLayout diagramLayout = this.layout;
        if (diagramLayout == null) {
            DiagramConfiguration.$$$reportNull$$$0(1);
        }
        return diagramLayout;
    }

    public void setDefaultLayout(@NotNull DiagramLayout defaultLayout) {
        if (defaultLayout == null) {
            DiagramConfiguration.$$$reportNull$$$0(2);
        }
        this.layout = defaultLayout;
    }

    @NotNull
    public String getDefaultScope() {
        String string = this.defaultScope;
        if (string == null) {
            DiagramConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setDefaultScope(@NotNull String defaultScope) {
        if (defaultScope == null) {
            DiagramConfiguration.$$$reportNull$$$0(4);
        }
        this.defaultScope = defaultScope;
    }

    @NotNull
    public DiagramLayoutOnCategorySwitch getLayoutOnCategorySwitch() {
        DiagramLayoutOnCategorySwitch diagramLayoutOnCategorySwitch = this.myLayoutOnCategorySwitch;
        if (diagramLayoutOnCategorySwitch == null) {
            DiagramConfiguration.$$$reportNull$$$0(5);
        }
        return diagramLayoutOnCategorySwitch;
    }

    public void setLayoutOnCategorySwitch(@NotNull DiagramLayoutOnCategorySwitch layoutOnCategorySwitch) {
        if (layoutOnCategorySwitch == null) {
            DiagramConfiguration.$$$reportNull$$$0(6);
        }
        this.myLayoutOnCategorySwitch = layoutOnCategorySwitch;
    }

    public boolean doFitContentAfterLayout() {
        return this.fitContentAfterLayout;
    }

    public void setDoFitContentAfterLayout(boolean doFitContentAfterLayout) {
        this.fitContentAfterLayout = doFitContentAfterLayout;
    }

    public boolean doRelayoutOnNewElements() {
        return this.relayoutOnNewElements;
    }

    public void setDoRelayoutOnNewElements(boolean doRelayoutOnNewElements) {
        this.relayoutOnNewElements = doRelayoutOnNewElements;
    }

    public boolean doShowGridByDefault() {
        return this.myDoShowGridByDefault;
    }

    public void setDoShowGridByDefault(boolean doShowGridByDefault) {
        this.myDoShowGridByDefault = doShowGridByDefault;
    }

    public boolean isAnimationsEnabled() {
        return this.myIsAnimationsEnabled;
    }

    public void setAnimationsEnabled(boolean isEnabled) {
        this.myIsAnimationsEnabled = isEnabled;
    }

    public boolean doNodeItemSyntaxHighlighting() {
        return this.myDoNodeItemSyntaxHighlighting;
    }

    public void setDoNodeItemSyntaxHighlighting(boolean doNodeItemSyntaxHighlighting) {
        this.myDoNodeItemSyntaxHighlighting = doNodeItemSyntaxHighlighting;
    }

    public int getShortenNodeItemOnLength() {
        return this.myShortenNodeItemOnLength;
    }

    public void setShortenNodeItemOnLength(int shortenNodeItemOnLength) {
        this.myShortenNodeItemOnLength = shortenNodeItemOnLength;
    }

    public int getLayoutAnimationDurationMillis() {
        return this.myLayoutAnimationDurationMillis;
    }

    public void setLayoutAnimationDurationMillis(int layoutAnimationDurationMillis) {
        this.myLayoutAnimationDurationMillis = layoutAnimationDurationMillis;
    }

    @NotNull
    public DiagramNodeItemStyle getDiagramNodeItemStyle() {
        DiagramNodeItemStyle diagramNodeItemStyle = this.myNodeItemStyle;
        if (diagramNodeItemStyle == null) {
            DiagramConfiguration.$$$reportNull$$$0(7);
        }
        return diagramNodeItemStyle;
    }

    public void setDiagramNodeItemStyle(@NotNull DiagramNodeItemStyle nodeStyle) {
        if (nodeStyle == null) {
            DiagramConfiguration.$$$reportNull$$$0(8);
        }
        this.myNodeItemStyle = nodeStyle;
    }

    public boolean isEnabledByDefault(@NotNull DiagramProvider<?> provider, @NotNull String categoryName) {
        if (provider == null) {
            DiagramConfiguration.$$$reportNull$$$0(9);
        }
        if (categoryName == null) {
            DiagramConfiguration.$$$reportNull$$$0(10);
        }
        String cats = this.categories.get(provider.getID());
        boolean enabledByDefault = DiagramConfiguration.getDefaultValue(provider, categoryName);
        if (cats == null) {
            return enabledByDefault;
        }
        return Arrays.asList(cats.split(";")).contains(categoryName) != enabledByDefault;
    }

    private static boolean getDefaultValue(@NotNull DiagramProvider<?> provider, @NotNull String categoryName) {
        if (provider == null) {
            DiagramConfiguration.$$$reportNull$$$0(11);
        }
        if (categoryName == null) {
            DiagramConfiguration.$$$reportNull$$$0(12);
        }
        for (DiagramCategory category : provider.getAllContentCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return category.isEnabledByDefault();
        }
        DiagramExtras<?> extras = provider.getExtras();
        for (DiagramConfigGroup group : extras.getAdditionalDiagramSettings()) {
            for (DiagramConfigElement element : group.getElements()) {
                if (!element.getName().equals(categoryName)) continue;
                return element.isChecked();
            }
        }
        throw new IllegalArgumentException("There is no element '" + categoryName + "' in UML provider " + provider.getID());
    }

    public DiagramConfiguration getState() {
        return this;
    }

    public void loadState(@NotNull DiagramConfiguration state) {
        if (state == null) {
            DiagramConfiguration.$$$reportNull$$$0(13);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public DiagramConfiguration clone() throws CloneNotSupportedException {
        return (DiagramConfiguration)super.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLayout";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutOnCategorySwitch";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeStyle";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLayout";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutOnCategorySwitch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagramNodeItemStyle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultLayout";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutOnCategorySwitch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDiagramNodeItemStyle";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledByDefault";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

