/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.templates;

import com.intellij.clouds.docker.gateway.DockerGatewayBundle;
import com.intellij.clouds.docker.gateway.templates.DevcontainerTemplateChooserDialogKt;
import com.intellij.clouds.docker.gateway.templates.OptionEditor;
import com.intellij.clouds.docker.gateway.templates.OptionsPanel;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureInfoProvidersKt;
import com.intellij.docker.agent.devcontainers.feautures.TemplateData;
import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0002()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0002J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120%J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/clouds/docker/gateway/templates/DevcontainerTemplateChooserDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "initialLocation", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "locationComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "optionsPanel", "Lcom/intellij/clouds/docker/gateway/templates/OptionsPanel;", "templatesCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/docker/agent/devcontainers/feautures/TemplateData;", "descriptionField", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JEditorPane;", "publisherPane", "templatePageUrl", "", "templateLink", "Lcom/intellij/ui/components/ActionLink;", "optionsGroup", "Lcom/intellij/ui/dsl/builder/Row;", "finalLocationInfoCell", "computeLocationAutomatically", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "generateCustomizationSection", "createCenterPanel", "Ljavax/swing/JComponent;", "isGenerateCustomizations", "computeWorkingDir", "computeTemplateFolderNameFromTemplateData", "updateOnSelection", "", "template", "getOptions", "", "getWorkingDir", "getSelectedTemplate", "Companion", "TemplateListCellRenderer", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerTemplateChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerTemplateChooserDialog.kt\ncom/intellij/clouds/docker/gateway/templates/DevcontainerTemplateChooserDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1#2:356\n1761#3,3:357\n774#3:360\n865#3,2:361\n1869#3,2:363\n*S KotlinDebug\n*F\n+ 1 DevcontainerTemplateChooserDialog.kt\ncom/intellij/clouds/docker/gateway/templates/DevcontainerTemplateChooserDialog\n*L\n189#1:357,3\n201#1:360\n201#1:361,2\n201#1:363,2\n*E\n"})
public final class DevcontainerTemplateChooserDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path initialLocation;
    @Nullable
    private TextFieldWithBrowseButton locationComponent;
    @Nullable
    private OptionsPanel optionsPanel;
    @Nullable
    private ComboBox<TemplateData> templatesCombo;
    @Nullable
    private Cell<? extends JEditorPane> descriptionField;
    @Nullable
    private JEditorPane publisherPane;
    @Nullable
    private String templatePageUrl;
    @Nullable
    private ActionLink templateLink;
    @Nullable
    private Row optionsGroup;
    @Nullable
    private Cell<? extends JEditorPane> finalLocationInfoCell;
    @NotNull
    private final AtomicProperty<Boolean> computeLocationAutomatically;
    private boolean generateCustomizationSection;
    private static final int DESCRIPTION_TEXT_MAX_WIDTH = 100;
    private static final int PREFERRED_TEMPLATE_LIST_WIDTH = JBUI.scale((int)500);
    private static final int MAX_OPTION_LIST_HEIGHT = JBUI.scale((int)100);

    public DevcontainerTemplateChooserDialog(@NotNull Path initialLocation) {
        Intrinsics.checkNotNullParameter((Object)initialLocation, (String)"initialLocation");
        super(false);
        this.initialLocation = initialLocation;
        this.computeLocationAutomatically = new AtomicProperty((Object)true);
        this.generateCustomizationSection = true;
        this.init();
        this.setTitle(DockerGatewayBundle.message("devcontainer.dialog.title.create.configuration", new Object[0]));
        this.setResizable(false);
        ComboBox<TemplateData> comboBox = this.templatesCombo;
        Object object = comboBox != null ? comboBox.getSelectedItem() : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.agent.devcontainers.feautures.TemplateData");
        this.updateOnSelection((TemplateData)object);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21(this, arg_0)).withBorder(JBUI.Borders.customLineBottom((Color)((Color)JBColor.lightGray)));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (JComponent)jBPanel;
    }

    public final boolean isGenerateCustomizations() {
        return this.generateCustomizationSection;
    }

    private final Path computeWorkingDir() {
        Path path;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.locationComponent;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path location = path2;
        if (((Boolean)this.computeLocationAutomatically.get()).booleanValue()) {
            if (location.endsWith(".devcontainer")) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(location, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || UtilsKt.isEmpty((Path)location)) {
                    path = location;
                } else {
                    Path path3 = location.resolve(this.computeTemplateFolderNameFromTemplateData());
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                    path = DevcontainerTemplateChooserDialogKt.access$generateUniqueFolderName(path3);
                }
            } else {
                Path devcontainerFolder = location.resolve(".devcontainer");
                Intrinsics.checkNotNull((Object)devcontainerFolder);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(devcontainerFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || UtilsKt.isEmpty((Path)devcontainerFolder)) {
                    path = devcontainerFolder;
                } else {
                    Path path4 = devcontainerFolder.resolve(this.computeTemplateFolderNameFromTemplateData());
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                    path = DevcontainerTemplateChooserDialogKt.access$generateUniqueFolderName(path4);
                }
            }
        } else {
            path = location;
        }
        return path;
    }

    private final String computeTemplateFolderNameFromTemplateData() {
        ComboBox<TemplateData> comboBox = this.templatesCombo;
        Intrinsics.checkNotNull(comboBox);
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.agent.devcontainers.feautures.TemplateData");
        String id = ((TemplateData)object).getId();
        String folderName = StringsKt.substringAfterLast$default((String)id, (char)'/', null, (int)2, null);
        CharSequence charSequence = folderName;
        Regex regex = new Regex("[^a-zA-Z0-9]");
        String string = "_";
        String normalizedFolderName = regex.replace(charSequence, string);
        return normalizedFolderName;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnSelection(TemplateData template) {
        Row row;
        Object it;
        Cell<? extends JEditorPane> cell = this.descriptionField;
        if (cell != null) {
            it = cell;
            boolean bl = false;
            ((JEditorPane)it.getComponent()).setText(template.getDescription());
        }
        JEditorPane jEditorPane = this.publisherPane;
        if (jEditorPane != null) {
            it = jEditorPane;
            boolean bl = false;
            ((JEditorPane)it).setText(Strings.isEmpty((String)template.getPublisher()) ? DockerGatewayBundle.message("devcontainer.template.publisher.unknown", new Object[0]) : template.getPublisher());
        }
        this.templatePageUrl = template.getDocumentationURL();
        ActionLink actionLink = this.templateLink;
        if (actionLink != null) {
            it = actionLink;
            boolean bl = false;
            it.setText(template.getDocumentationURL());
        }
        OptionsPanel optionsPanel = this.optionsPanel;
        if (optionsPanel != null) {
            optionsPanel.setup(template.getOptions());
        }
        if ((row = this.optionsGroup) != null) {
            boolean bl;
            Object object = this.optionsPanel;
            if (object != null && (object = ((OptionsPanel)object).getEditors()) != null) {
                boolean bl2;
                Row row2;
                block11: {
                    void $this$any$iv;
                    Iterable iterable = (Iterable)object;
                    row2 = row;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            OptionEditor it2 = (OptionEditor)element$iv;
                            boolean bl3 = false;
                            if (!it2.isVisible()) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                boolean bl4 = bl2;
                row = row2;
                bl = bl4;
            } else {
                bl = false;
            }
            row.visible(bl);
        }
        if (((Boolean)this.computeLocationAutomatically.get()).booleanValue()) {
            Cell<? extends JEditorPane> cell2 = this.finalLocationInfoCell;
            Intrinsics.checkNotNull(cell2);
            TextFieldKt.text(cell2, (String)("Files will be generated in: " + ((Object)this.computeWorkingDir()).toString()));
        }
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getOptions() {
        Map result2;
        block2: {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            result2 = new LinkedHashMap();
            OptionsPanel optionsPanel = this.optionsPanel;
            if (optionsPanel == null) break block2;
            OptionsPanel panel2 = optionsPanel;
            boolean bl = false;
            Iterable $this$filter$iv = panel2.getEditors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OptionEditor it = (OptionEditor)element$iv$iv;
                boolean bl2 = false;
                if (!it.isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it;
                String id;
                OptionEditor optionEditor = (OptionEditor)element$iv;
                boolean bl3 = false;
                if (optionEditor.getOptionId() == null) continue;
                boolean bl4 = false;
                if (optionEditor.getOptionValue() == null) continue;
                boolean bl5 = false;
                result2.put(id, it);
            }
        }
        return result2;
    }

    @NotNull
    public final Path getWorkingDir() {
        return this.computeWorkingDir();
    }

    @NotNull
    public final TemplateData getSelectedTemplate() {
        ComboBox<TemplateData> comboBox = this.templatesCombo;
        Object object = comboBox != null ? comboBox.getSelectedItem() : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.agent.devcontainers.feautures.TemplateData");
        return (TemplateData)object;
    }

    private static final String createCenterPanel$lambda$21$lambda$1$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$1(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell component = Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)new FileChooserDescriptor(false, true, false, false, false, false), null, DevcontainerTemplateChooserDialog::createCenterPanel$lambda$21$lambda$1$lambda$0, (int)2, null).align(Align.FILL);
        TextFieldWithBrowseButtonKt.text((Cell)component, (String)((Object)this$0.initialLocation).toString());
        this$0.locationComponent = (TextFieldWithBrowseButton)component.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$3$lambda$2(DevcontainerTemplateChooserDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.computeLocationAutomatically.set((Object)it.isSelected());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$3(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DockerGatewayBundle.message("DevcontainerTemplateChooserDialog.checkbox.compute.location.automatically", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.selected((Cell)$this$row.checkBox(string).onChanged(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$3$lambda$2(this$0, arg_0)), (boolean)((Boolean)this$0.computeLocationAutomatically.get()));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$4(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.finalLocationInfoCell = Row.comment$default((Row)$this$row, (String)"", (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$8$lambda$6(Collection $templates, ComboBox $this$applyToComponent) {
        Object v0;
        ComboBox comboBox;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            $this$applyToComponent.setPreferredSize(new Dimension(PREFERRED_TEMPLATE_LIST_WIDTH, UiSizeUtilKt.getPreferredHeight((JComponent)((JComponent)$this$applyToComponent))));
            $this$applyToComponent.setRenderer((ListCellRenderer)((Object)new TemplateListCellRenderer(PREFERRED_TEMPLATE_LIST_WIDTH - 35)));
            $this$applyToComponent.setSwingPopup(false);
            Iterable iterable = $templates;
            comboBox = $this$applyToComponent;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                TemplateData it = (TemplateData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Default")) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        comboBox.setSelectedItem(v0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$8$lambda$7(DevcontainerTemplateChooserDialog this$0, ComboBox combo) {
        Intrinsics.checkNotNullParameter((Object)combo, (String)"combo");
        Object object = combo.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.agent.devcontainers.feautures.TemplateData");
        this$0.updateOnSelection((TemplateData)object);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$8(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DockerGatewayBundle.message("devcontainer.template.border.title.template", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Collection templates = DevcontainerFeatureInfoProvidersKt.getDevcontainerTemplates();
        Cell combo = Row.comboBox$default((Row)$this$row, (Collection)templates, null, (int)2, null).applyToComponent(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$8$lambda$6(templates, arg_0)).onChanged(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$8$lambda$7(this$0, arg_0));
        this$0.templatesCombo = (ComboBox)combo.getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$14$lambda$11$lambda$10(DevcontainerTemplateChooserDialog this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = this$0.templatePageUrl;
            if (string == null) break block0;
            String it2 = string;
            boolean bl = false;
            BrowserUtil.browse((String)it2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$14$lambda$11(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.templateLink = (ActionLink)$this$row.link("", arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$14$lambda$11$lambda$10(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$14$lambda$12(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.descriptionField = Row.comment$default((Row)$this$row, (String)"", (int)100, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$14$lambda$13(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DockerGatewayBundle.message("devcontainer.template.label.publisher", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        this$0.publisherPane = (JEditorPane)Row.comment$default((Row)$this$row, (String)"", (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$14(DevcontainerTemplateChooserDialog this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$14$lambda$11(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$14$lambda$12(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$14$lambda$13(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$17$lambda$16(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        OptionsPanel it = new OptionsPanel();
        boolean bl = false;
        this$0.optionsPanel = it;
        JBScrollPane scrollPane = new JBScrollPane((Component)it);
        scrollPane.setMaximumSize((Dimension)new JBDimension(scrollPane.getMaximumSize().width, MAX_OPTION_LIST_HEIGHT));
        scrollPane.setPreferredSize((Dimension)new JBDimension(PREFERRED_TEMPLATE_LIST_WIDTH, MAX_OPTION_LIST_HEIGHT));
        $this$row.cell((JComponent)scrollPane);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$17(DevcontainerTemplateChooserDialog this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$17$lambda$16(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21$lambda$20$lambda$18(DevcontainerTemplateChooserDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.generateCustomizationSection = it.isSelected();
        return Unit.INSTANCE;
    }

    private static final boolean createCenterPanel$lambda$21$lambda$20$lambda$19(TemplateData it) {
        TemplateData templateData = it;
        return !Intrinsics.areEqual((Object)(templateData != null ? templateData.getOwner() : null), (Object)"JetBrains");
    }

    private static final Unit createCenterPanel$lambda$21$lambda$20(DevcontainerTemplateChooserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DockerGatewayBundle.message("devcontainer.template.generate.customizations.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = ButtonKt.selected((Cell)$this$row.checkBox(string).onChanged(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$20$lambda$18(this$0, arg_0)), (boolean)this$0.generateCustomizationSection);
        ComboBox<TemplateData> comboBox = this$0.templatesCombo;
        Intrinsics.checkNotNull(comboBox);
        cell.enabledIf(ComponentPredicateKt.selectedValueMatches((JComboBox)((JComboBox)comboBox), DevcontainerTemplateChooserDialog::createCenterPanel$lambda$21$lambda$20$lambda$19));
        String string2 = DockerGatewayBundle.message("devcontainer.template.customizations.hint", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
        $this$row.bottomGap(BottomGap.MEDIUM);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$21(DevcontainerTemplateChooserDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = DockerGatewayBundle.message("DevcontainerTemplateChooserDialog.location", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$4(this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)this$0.computeLocationAutomatically);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$8(this$0, arg_0), (int)1, null);
        $this$panel.indent(arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$14(this$0, arg_0));
        this$0.optionsGroup = Panel.group$default((Panel)$this$panel, (String)DockerGatewayBundle.message("devcontainer.template.border.title.options", new Object[0]), (boolean)false, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$17(this$0, arg_0), (int)2, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DevcontainerTemplateChooserDialog.createCenterPanel$lambda$21$lambda$20(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/docker/gateway/templates/DevcontainerTemplateChooserDialog$Companion;", "", "<init>", "()V", "DESCRIPTION_TEXT_MAX_WIDTH", "", "PREFERRED_TEMPLATE_LIST_WIDTH", "MAX_OPTION_LIST_HEIGHT", "intellij.clouds.docker.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/clouds/docker/gateway/templates/DevcontainerTemplateChooserDialog$TemplateListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/docker/agent/devcontainers/feautures/TemplateData;", "listWidth", "", "<init>", "(I)V", "getListWidth", "()I", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "selected", "", "hasFocus", "intellij.clouds.docker.gateway"})
    private static final class TemplateListCellRenderer
    extends ColoredListCellRenderer<TemplateData> {
        private final int listWidth;

        public TemplateListCellRenderer(int listWidth) {
            this.listWidth = listWidth;
        }

        public final int getListWidth() {
            return this.listWidth;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends TemplateData> list, @Nullable TemplateData value, int index, boolean selected, boolean hasFocus) {
            block3: {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                TemplateData templateData = value;
                if (templateData == null) break block3;
                TemplateData templateData2 = templateData;
                boolean bl = false;
                FontMetrics fm = this.getFontMetrics(this.getFont());
                this.append(templateData2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (index >= 0) {
                    String string = templateData2.getDescription();
                    if (string != null) {
                        String it = string;
                        boolean bl2 = false;
                        this.append("  ");
                        int remWidth = this.listWidth - fm.stringWidth(templateData2.getName() + "  ");
                        if (remWidth > 0) {
                            String description = SwingHelper.truncateStringWithEllipsis((String)it, (int)remWidth, (FontMetrics)fm);
                            this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        }
                    }
                }
            }
        }
    }
}

