/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequestsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/RequestToExternalEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "source", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "target", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramExternalEndpoint;", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "pathReference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "<init>", "(Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;Lcom/intellij/microservices/ui/diagrams/model/MsDiagramExternalEndpoint;Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/microservices/url/references/UrlPathReference;)V", "getSource", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "getTarget", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramExternalEndpoint;", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "getPathReference", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "resolveToSourcePsiElement", "Lcom/intellij/psi/PsiElement;", "toRelationship", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.microservices.ui.diagrams"})
public final class RequestToExternalEndpoint
extends MsDiagramRequest {
    @NotNull
    private final MsDiagramWebservice source;
    @NotNull
    private final MsDiagramExternalEndpoint target;
    @Nullable
    private final UrlTargetInfo targetInfo;
    @Nullable
    private final UrlPathReference pathReference;

    public RequestToExternalEndpoint(@NotNull MsDiagramWebservice source, @NotNull MsDiagramExternalEndpoint target, @Nullable UrlTargetInfo targetInfo, @Nullable UrlPathReference pathReference) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(null);
        this.source = source;
        this.target = target;
        this.targetInfo = targetInfo;
        this.pathReference = pathReference;
    }

    @Override
    @NotNull
    public MsDiagramWebservice getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public MsDiagramExternalEndpoint getTarget() {
        return this.target;
    }

    @Nullable
    public final UrlTargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    @Nullable
    public final UrlPathReference getPathReference() {
        return this.pathReference;
    }

    @Override
    @Nullable
    public PsiElement resolveToSourcePsiElement() {
        UrlPathReference urlPathReference = this.pathReference;
        return urlPathReference != null ? urlPathReference.getElement() : null;
    }

    @Override
    @NotNull
    public MsDiagramRelationship toRelationship() {
        return MsDiagramRequestsKt.access$urlRequestToRelationship(this.targetInfo);
    }

    @NotNull
    public final MsDiagramWebservice component1() {
        return this.source;
    }

    @NotNull
    public final MsDiagramExternalEndpoint component2() {
        return this.target;
    }

    @Nullable
    public final UrlTargetInfo component3() {
        return this.targetInfo;
    }

    @Nullable
    public final UrlPathReference component4() {
        return this.pathReference;
    }

    @NotNull
    public final RequestToExternalEndpoint copy(@NotNull MsDiagramWebservice source, @NotNull MsDiagramExternalEndpoint target, @Nullable UrlTargetInfo targetInfo, @Nullable UrlPathReference pathReference) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new RequestToExternalEndpoint(source, target, targetInfo, pathReference);
    }

    public static /* synthetic */ RequestToExternalEndpoint copy$default(RequestToExternalEndpoint requestToExternalEndpoint, MsDiagramWebservice msDiagramWebservice, MsDiagramExternalEndpoint msDiagramExternalEndpoint, UrlTargetInfo urlTargetInfo, UrlPathReference urlPathReference, int n, Object object) {
        if ((n & 1) != 0) {
            msDiagramWebservice = requestToExternalEndpoint.source;
        }
        if ((n & 2) != 0) {
            msDiagramExternalEndpoint = requestToExternalEndpoint.target;
        }
        if ((n & 4) != 0) {
            urlTargetInfo = requestToExternalEndpoint.targetInfo;
        }
        if ((n & 8) != 0) {
            urlPathReference = requestToExternalEndpoint.pathReference;
        }
        return requestToExternalEndpoint.copy(msDiagramWebservice, msDiagramExternalEndpoint, urlTargetInfo, urlPathReference);
    }

    @NotNull
    public String toString() {
        return "RequestToExternalEndpoint(source=" + this.source + ", target=" + this.target + ", targetInfo=" + this.targetInfo + ", pathReference=" + this.pathReference + ")";
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + this.target.hashCode();
        result = result * 31 + (this.targetInfo == null ? 0 : this.targetInfo.hashCode());
        result = result * 31 + (this.pathReference == null ? 0 : this.pathReference.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestToExternalEndpoint)) {
            return false;
        }
        RequestToExternalEndpoint requestToExternalEndpoint = (RequestToExternalEndpoint)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)requestToExternalEndpoint.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.target, (Object)requestToExternalEndpoint.target)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetInfo, (Object)requestToExternalEndpoint.targetInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pathReference, (Object)requestToExternalEndpoint.pathReference);
    }
}

