/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchFileType
implements FileType {
    public static final PatchFileType INSTANCE = new PatchFileType();
    public static final String NAME = "PATCH";

    private PatchFileType() {
    }

    @NotNull
    @NonNls
    public String getName() {
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = VcsBundle.message((String)"filetype.patch.description", (Object[])new Object[0]);
        if (string == null) {
            PatchFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = VcsBundle.message((String)"filetype.patch.display.name", (Object[])new Object[0]);
        if (string == null) {
            PatchFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        return "patch";
    }

    public Icon getIcon() {
        return AllIcons.Vcs.Patch_file;
    }

    public boolean isBinary() {
        return false;
    }

    public static boolean isPatchFile(@Nullable VirtualFile vFile) {
        return vFile != null && FileTypeRegistry.getInstance().isFileOfType(vFile, (FileType)INSTANCE);
    }

    public static boolean isPatchFile(@NotNull File file) {
        if (file == null) {
            PatchFileType.$$$reportNull$$$0(2);
        }
        return PatchFileType.isPatchFile(VfsUtil.findFileByIoFile((File)file, (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/PatchFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/PatchFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPatchFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

