/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ReadonlyStatusIsVisibleActivationCheck;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationsWriteableFilesVfsListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ShelfUtils;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.OpenedResultProcessor;
import org.jetbrains.idea.perforce.application.PerforceAnnotationProvider;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceCheckinEnvironment;
import org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider;
import org.jetbrains.idea.perforce.application.PerforceDiffProvider;
import org.jetbrains.idea.perforce.application.PerforceDisposable;
import org.jetbrains.idea.perforce.application.PerforceExceptionsHotFixer;
import org.jetbrains.idea.perforce.application.PerforceIntegrateEnvironment;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceOfflineChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceOfflineRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceTreeDiffProvider;
import org.jetbrains.idea.perforce.application.PerforceUpdateEnvironment;
import org.jetbrains.idea.perforce.application.PerforceVFSListener;
import org.jetbrains.idea.perforce.application.PerforceVcsHistoryProvider;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public final class PerforceVcs
extends AbstractVcs {
    @NlsSafe
    public static final String NAME = "Perforce";
    private static final VcsKey ourKey = PerforceVcs.createKey((String)"Perforce");
    private PerforceCheckinEnvironment myPerforceCheckinEnvironment;
    private PerforceUpdateEnvironment myPerforceUpdateEnvironment;
    private PerforceIntegrateEnvironment myPerforceIntegrateEnvironment;
    private RollbackEnvironment myPerforceRollbackEnvironment;
    private RollbackEnvironment myOfflineRollbackEnvironment;
    private PerforceCommittedChangesProvider myCommittedChangesProvider;
    private final MyEditFileProvider myMyEditFileProvider;
    private PerforceChangeProvider myChangeProvider;
    private ChangeProvider myOfflineChangeProvider;
    private PerforceVcsHistoryProvider myHistoryProvider;
    private PerforceAnnotationProvider myAnnotationProvider;
    private PerforceDiffProvider myDiffProvider;
    private PerforceTreeDiffProvider myTreeDiffProvider;
    private MergeProvider myMergeProvider;
    private final AtomicReference<CoroutineScope> myActiveScope;
    private final Set<VirtualFile> myAsyncEditFiles;
    private final Map<ConnectionKey, List<PerforceJob>> myDefaultAssociated;
    private final ReentrantReadWriteLock myP4Lock;

    public PerforceVcs(@NotNull Project project) {
        if (project == null) {
            PerforceVcs.$$$reportNull$$$0(0);
        }
        super(project, NAME);
        this.myActiveScope = new AtomicReference();
        this.myAsyncEditFiles = new HashSet<VirtualFile>();
        this.myDefaultAssociated = new HashMap<ConnectionKey, List<PerforceJob>>();
        this.myP4Lock = new ReentrantReadWriteLock();
        this.myMyEditFileProvider = new MyEditFileProvider();
    }

    @NotNull
    public String getDisplayName() {
        return NAME;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        String string = PerforceBundle.message("perforce.name.with.mnemonic", new Object[0]);
        if (string == null) {
            PerforceVcs.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isCommitActionDisabled() {
        return !PerforceSettings.getSettings((Project)this.myProject).ENABLED;
    }

    public boolean isUpdateActionDisabled() {
        return !PerforceSettings.getSettings((Project)this.myProject).ENABLED;
    }

    @Nullable
    private <T> T validProvider(T initialValue) {
        return (T)(this.getSettings().ENABLED ? initialValue : null);
    }

    public boolean allowsRemoteCalls(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceVcs.$$$reportNull$$$0(2);
        }
        return this.getSettings().ENABLED;
    }

    public boolean isTrackingUnchangedContent() {
        return true;
    }

    @NotNull
    public EditFileProvider getEditFileProvider() {
        MyEditFileProvider myEditFileProvider = this.myMyEditFileProvider;
        if (myEditFileProvider == null) {
            PerforceVcs.$$$reportNull$$$0(3);
        }
        return myEditFileProvider;
    }

    @NotNull
    public PerforceCheckinEnvironment getCheckinEnvironment() {
        if (this.myPerforceCheckinEnvironment == null) {
            this.myPerforceCheckinEnvironment = new PerforceCheckinEnvironment(this.myProject, this);
        }
        PerforceCheckinEnvironment perforceCheckinEnvironment = this.myPerforceCheckinEnvironment;
        if (perforceCheckinEnvironment == null) {
            PerforceVcs.$$$reportNull$$$0(4);
        }
        return perforceCheckinEnvironment;
    }

    public RollbackEnvironment getRollbackEnvironment() {
        if (PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            if (this.myPerforceRollbackEnvironment == null) {
                this.myPerforceRollbackEnvironment = new PerforceRollbackEnvironment(this.myProject);
            }
            return this.myPerforceRollbackEnvironment;
        }
        if (this.myOfflineRollbackEnvironment == null) {
            this.myOfflineRollbackEnvironment = new PerforceOfflineRollbackEnvironment(this.myProject);
        }
        return this.myOfflineRollbackEnvironment;
    }

    private void autoEditVFile(VirtualFile[] vFiles) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file : vFiles) {
                PerforceVFSListener.updateLastUnchangedContent(file, changeListManager);
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file, (boolean)false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.startAsyncEdit(vFiles);
        ArrayList<P4EditOperation> operations = new ArrayList<P4EditOperation>();
        for (VirtualFile vFile : vFiles) {
            LocalChangeList list = changeListManager.getChangeList(vFile);
            if (list == null) {
                list = changeListManager.getDefaultChangeList();
            }
            operations.add(new P4EditOperation(list.getName(), vFile, false));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message("progress.title.perforce.edit", new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND, () -> this.refreshFiles(vFiles));
    }

    public void refreshFiles(VirtualFile ... filesToRefresh) {
        if (filesToRefresh == null) {
            PerforceVcs.$$$reportNull$$$0(5);
        }
        List<VirtualFile> files = Arrays.asList(filesToRefresh);
        LocalFileSystem.getInstance().refreshFiles(files, true, false, null);
        this.asyncEditCompleted(files);
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(files, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsyncEdit(VirtualFile ... vFiles) {
        if (vFiles == null) {
            PerforceVcs.$$$reportNull$$$0(6);
        }
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            Collections.addAll(this.myAsyncEditFiles, vFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VirtualFile> getAsyncEditedFiles() {
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            return new HashSet<VirtualFile>(this.myAsyncEditFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncEditCompleted(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            PerforceVcs.$$$reportNull$$$0(7);
        }
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            this.myAsyncEditFiles.removeAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncEditCompleted(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceVcs.$$$reportNull$$$0(8);
        }
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            this.myAsyncEditFiles.remove(file);
        }
    }

    public static PerforceVcs getInstance(Project project) {
        return (PerforceVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    @NotNull
    public UpdateEnvironment getUpdateEnvironment() {
        if (this.myPerforceUpdateEnvironment == null) {
            this.myPerforceUpdateEnvironment = new PerforceUpdateEnvironment(this.myProject);
        }
        PerforceUpdateEnvironment perforceUpdateEnvironment = this.myPerforceUpdateEnvironment;
        if (perforceUpdateEnvironment == null) {
            PerforceVcs.$$$reportNull$$$0(9);
        }
        return perforceUpdateEnvironment;
    }

    public PerforceSettings getSettings() {
        return PerforceSettings.getSettings(this.myProject);
    }

    @Nullable
    public static String getFileNameComplaint(P4File file) {
        String filename = file.getLocalPath();
        if (StringUtil.containsAnyChar((String)filename, (String)"@#%*")) {
            return PerforceBundle.message("file.wildcards.restricted", filename);
        }
        return null;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        try {
            if (virtualFile.isDirectory()) {
                return PerforceManager.getInstance(this.getProject()).isUnderPerforceRoot(virtualFile);
            }
            P4File p4File = P4File.create(virtualFile);
            return PerforceRunner.getInstance(this.myProject).have(p4File);
        }
        catch (VcsException e) {
            return false;
        }
    }

    public boolean fileExistsInVcs(FilePath filePath) {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        PerforceManager perforceManager = PerforceManager.getInstance(this.getProject());
        if (!this.getSettings().ENABLED) {
            return true;
        }
        if (virtualFile.isDirectory()) {
            try {
                return perforceManager.isUnderPerforceRoot(virtualFile);
            }
            catch (VcsException e) {
                return false;
            }
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
        if (FileStatus.ADDED.equals(fileStatus) && Boolean.TRUE.equals(virtualFile.getUserData(OpenedResultProcessor.BRANCHED_FILE))) {
            return true;
        }
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        if (this.myHistoryProvider == null) {
            this.myHistoryProvider = new PerforceVcsHistoryProvider(this);
        }
        return this.validProvider(this.myHistoryProvider);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new PerforceAnnotationProvider(this.myProject);
        }
        return (AnnotationProvider)this.validProvider(this.myAnnotationProvider);
    }

    public DiffProvider getDiffProvider() {
        if (this.myDiffProvider == null) {
            this.myDiffProvider = new PerforceDiffProvider(this.myProject);
        }
        return (DiffProvider)this.validProvider(this.myDiffProvider);
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.getSettings().ENABLED) {
            PerforceChangeProvider perforceChangeProvider = this.getOnlineChangeProvider();
            if (perforceChangeProvider == null) {
                PerforceVcs.$$$reportNull$$$0(10);
            }
            return perforceChangeProvider;
        }
        if (this.myOfflineChangeProvider == null) {
            this.myOfflineChangeProvider = new PerforceOfflineChangeProvider(this.myProject);
        }
        ChangeProvider changeProvider = this.myOfflineChangeProvider;
        if (changeProvider == null) {
            PerforceVcs.$$$reportNull$$$0(11);
        }
        return changeProvider;
    }

    public PerforceChangeProvider getOnlineChangeProvider() {
        this.initChangeProvider();
        return this.myChangeProvider;
    }

    private void initChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new PerforceChangeProvider(this);
        }
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.myPerforceIntegrateEnvironment == null) {
            this.myPerforceIntegrateEnvironment = new PerforceIntegrateEnvironment(this.myProject);
        }
        return this.validProvider(this.myPerforceIntegrateEnvironment);
    }

    public void activate() {
        CoroutineScope globalScope = PerforceDisposable.getCoroutineScope(this.myProject);
        CoroutineScope activeScope = CoroutineScopeKt.childScope((CoroutineScope)globalScope, (String)"PerforceVcs", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true);
        Disposable disposable = Disposer.newDisposable();
        AppJavaExecutorUtil.awaitCancellationAndDispose((CoroutineScope)activeScope, (Disposable)disposable);
        Disposer.register((Disposable)disposable, (Disposable)PerforceVFSListener.createInstance(this.myProject, activeScope));
        PerforceManager.getInstance(this.myProject).startListening(disposable);
        ((PerforceConnectionManager)PerforceConnectionManager.getInstance(this.myProject)).startListening(disposable);
        PerforceNumberNameSynchronizer.getInstance(this.myProject).startListening(disposable);
        PerforceSettings.getSettings(this.myProject).ensureOfflineNotify();
        ReadonlyStatusIsVisibleActivationCheck.check((Project)this.myProject, (String)NAME);
        this.initChangeProvider();
        this.myChangeProvider.activate(disposable);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new AnnotationsWriteableFilesVfsListener(this.myProject, PerforceVcs.getKey()), disposable);
    }

    public void deactivate() {
        CoroutineScope oldScope = this.myActiveScope.getAndSet(null);
        if (oldScope != null) {
            kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)oldScope, null);
        }
    }

    @NotNull
    public PerforceCommittedChangesProvider getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new PerforceCommittedChangesProvider(this.myProject);
        }
        PerforceCommittedChangesProvider perforceCommittedChangesProvider = this.myCommittedChangesProvider;
        if (perforceCommittedChangesProvider == null) {
            PerforceVcs.$$$reportNull$$$0(12);
        }
        return perforceCommittedChangesProvider;
    }

    public void runBackgroundTask(@NlsContexts.ProgressTitle @NotNull String title, @NotNull PerformInBackgroundOption option, final @NotNull Runnable runnable, final @Nullable Runnable edtCallback) {
        if (title == null) {
            PerforceVcs.$$$reportNull$$$0(13);
        }
        if (option == null) {
            PerforceVcs.$$$reportNull$$$0(14);
        }
        if (runnable == null) {
            PerforceVcs.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
            if (edtCallback != null) {
                edtCallback.run();
            }
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, false, option){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable.run();
                }

                public void onFinished() {
                    if (edtCallback != null) {
                        edtCallback.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/application/PerforceVcs$1", "run"));
                }
            });
        }
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        long revision;
        try {
            revision = Long.parseLong(revisionNumberString);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new PerforceOnlyRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new PerforceMergeProvider(this.myProject);
        }
        MergeProvider mergeProvider = this.myMergeProvider;
        if (mergeProvider == null) {
            PerforceVcs.$$$reportNull$$$0(16);
        }
        return mergeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ConnectionKey, List<PerforceJob>> getDefaultAssociated() {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            return new HashMap<ConnectionKey, List<PerforceJob>>(this.myDefaultAssociated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssociated(Map<ConnectionKey, List<PerforceJob>> jobs) {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            this.myDefaultAssociated.clear();
            this.myDefaultAssociated.putAll(jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDefaultAssociated() {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            this.myDefaultAssociated.clear();
        }
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        try {
            return PerforceManager.getInstance(this.myProject).isUnderPerforceRoot(dir);
        }
        catch (VcsException e) {
            return false;
        }
    }

    public VcsExceptionsHotFixer getVcsExceptionsHotFixer() {
        return (VcsExceptionsHotFixer)this.myProject.getService(PerforceExceptionsHotFixer.class);
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public Collection<Pair<P4Connection, Collection<VirtualFile>>> getRootsByConnections() throws VcsException {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(this.myProject);
        VirtualFile[] roots = vcsManager.getRootsUnderVcs((AbstractVcs)this);
        MultiMap rootsByConnections = new MultiMap();
        HashMap<ConnectionKey, P4Connection> connMap = new HashMap<ConnectionKey, P4Connection>();
        for (VirtualFile root : roots) {
            P4Connection connection = connectionManager.getConnectionForFile(root);
            if (connection == null) continue;
            PerforceManager.ensureValidClient(this.myProject, connection);
            ConnectionKey key = connection.getConnectionKey();
            connMap.put(key, connection);
            rootsByConnections.putValue((Object)key, (Object)root);
        }
        LinkedList<Pair<P4Connection, Collection<VirtualFile>>> result = new LinkedList<Pair<P4Connection, Collection<VirtualFile>>>();
        for (ConnectionKey key : rootsByConnections.keySet()) {
            P4Connection connection = (P4Connection)connMap.get(key);
            result.add((Pair<P4Connection, Collection<VirtualFile>>)Pair.create((Object)connection, (Object)rootsByConnections.get((Object)key)));
        }
        return result;
    }

    protected TreeDiffProvider getTreeDiffProviderImpl() {
        if (this.myTreeDiffProvider == null) {
            this.myTreeDiffProvider = new PerforceTreeDiffProvider(this);
        }
        return this.myTreeDiffProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public static boolean revisionsSame(@NotNull VcsRevisionNumber number1, @NotNull VcsRevisionNumber number2) {
        if (number1 == null) {
            PerforceVcs.$$$reportNull$$$0(17);
        }
        if (number2 == null) {
            PerforceVcs.$$$reportNull$$$0(18);
        }
        long revision1 = PerforceVcs.extractNumber(number1);
        long revision2 = PerforceVcs.extractNumber(number2);
        return revision1 > 0L && revision1 == revision2;
    }

    private static long extractNumber(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            PerforceVcs.$$$reportNull$$$0(19);
        }
        if (number instanceof VcsRevisionNumber.Long) {
            return ((VcsRevisionNumber.Long)number).getLongValue();
        }
        if (number instanceof PerforceVcsRevisionNumber) {
            return ((PerforceVcsRevisionNumber)number).getChangeNumber();
        }
        if (number instanceof PerforceOnlyRevisionNumber) {
            return ((PerforceOnlyRevisionNumber)number).getNumber();
        }
        return -1L;
    }

    @NotNull
    public ThreeState mayRemoveChangeList(@NotNull LocalChangeList list, boolean explicitly) {
        List<ShelvedChange> shelvedChanges;
        if (list == null) {
            PerforceVcs.$$$reportNull$$$0(20);
        }
        if (!(shelvedChanges = PerforceManager.getInstance(this.myProject).getShelf().getShelvedChanges(list)).isEmpty()) {
            if (!explicitly) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    PerforceVcs.$$$reportNull$$$0(21);
                }
                return threeState;
            }
            String message = PerforceBundle.message("changelist.shelved.changes.delete", list.getName());
            int rc = Messages.showDialog((Project)this.myProject, (String)message, (String)PerforceBundle.message("changelist.shelved.changes.found", new Object[0]), (String[])new String[]{PerforceBundle.message("shelf.browse.mnemonic", new Object[0]), IdeBundle.message((String)"button.remove", (Object[])new Object[0]), Messages.getCancelButton()}, (int)0, (Icon)Messages.getQuestionIcon());
            if (rc == 1) {
                ShelfUtils.deleteFromShelf(shelvedChanges, this.myProject);
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    PerforceVcs.$$$reportNull$$$0(22);
                }
                return threeState;
            }
            if (rc == 0) {
                ShelfUtils.browseShelf(this.myProject, shelvedChanges);
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                PerforceVcs.$$$reportNull$$$0(23);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            PerforceVcs.$$$reportNull$$$0(24);
        }
        return threeState;
    }

    public AccessToken readLockP4() {
        final ReentrantReadWriteLock.ReadLock lock = this.myP4Lock.readLock();
        lock.lock();
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    public AccessToken writeLockP4() {
        final ReentrantReadWriteLock.WriteLock lock = this.myP4Lock.writeLock();
        lock.lock();
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 9, 10, 11, 12, 16, 21, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceVcs";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRefresh";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameWithMnemonic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditFileProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckinEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateEnvironment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChangesProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeProvider";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "mayRemoveChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allowsRemoteCalls";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startAsyncEdit";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asyncEditCompleted";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runBackgroundTask";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "revisionsSame";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extractNumber";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mayRemoveChangeList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 9, 10, 11, 12, 16, 21, 22, 23, 24 -> new IllegalStateException(string);
        };
    }

    private class MyEditFileProvider
    implements EditFileProvider {
        private MyEditFileProvider() {
        }

        public void editFiles(VirtualFile[] files) {
            PerforceVcs.this.autoEditVFile(files);
        }

        public String getRequestText() {
            return PerforceBundle.message("confirmation.text.open.files.for.edit", new Object[0]);
        }
    }
}

