/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsSharedChecker;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.OutputMessageParser;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4SharedInVcsChecker;", "Lcom/intellij/openapi/vcs/VcsSharedChecker;", "<init>", "()V", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "isPathSharedInVcs", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "Companion", "intellij.vcs.perforce"})
@SourceDebugExtension(value={"SMAP\nP4SharedInVcsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4SharedInVcsChecker.kt\norg/jetbrains/idea/perforce/perforce/P4SharedInVcsChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,31:1\n14#2:32\n*S KotlinDebug\n*F\n+ 1 P4SharedInVcsChecker.kt\norg/jetbrains/idea/perforce/perforce/P4SharedInVcsChecker\n*L\n13#1:32\n*E\n"})
public final class P4SharedInVcsChecker
implements VcsSharedChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = PerforceVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    public boolean isPathSharedInVcs(@NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        P4File p4File = P4File.create(path.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)p4File, (String)"create(...)");
        P4File dir = p4File;
        Object[] objectArray = new String[]{"changes", dir.getRecursivePath()};
        Object[] p4args = objectArray;
        P4Connection p4Connection = PerforceConnectionManager.getInstance(project).getConnectionForFile(dir);
        if (p4Connection == null) {
            return false;
        }
        P4Connection connection = p4Connection;
        ExecResult execResult = PerforceRunner.getInstance(project).executeP4Command((String[])p4args, connection);
        if (execResult.getExitCode() != 0) {
            LOG.debug("Failed to check changes under " + dir + ", P4 command " + ArraysKt.joinToString$default((Object[])p4args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ", result " + execResult);
        }
        List<String> list = OutputMessageParser.readOutputLines(execResult.getStdout());
        Intrinsics.checkNotNullExpressionValue(list, (String)"readOutputLines(...)");
        return !((Collection)list).isEmpty();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(P4SharedInVcsChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/perforce/perforce/P4SharedInVcsChecker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

