/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.SignatureBasedProfilerDumpParserProvider;
import com.intellij.profiler.compressed.CompressedDumpDescriptor;
import com.intellij.profiler.compressed.CompressedDumpDescriptorFactory;
import com.intellij.profiler.compressed.CompressedDumpFileParserProviderWrapper;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J \u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002J \u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ProfilerDumpParserProviderFinder;", "", "<init>", "()V", "findParserProvider", "Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result;", "file", "Ljava/io/File;", "providers", "", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "findProviderByDumpSignature", "findRegularProvider", "inputStream", "Ljava/io/InputStream;", "Lcom/intellij/profiler/api/SignatureBasedProfilerDumpParserProvider;", "findCompressedProvider", "Result", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerDumpParserProviderFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerDumpParserProviderFinder.kt\ncom/intellij/profiler/ProfilerDumpParserProviderFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n808#2,11:83\n3301#2,10:94\n808#2,11:105\n1761#2,3:116\n1#3:104\n14#4:119\n*S KotlinDebug\n*F\n+ 1 ProfilerDumpParserProviderFinder.kt\ncom/intellij/profiler/ProfilerDumpParserProviderFinder\n*L\n17#1:83,11\n33#1:94,10\n46#1:105,11\n62#1:116,3\n79#1:119\n*E\n"})
public final class ProfilerDumpParserProviderFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result findParserProvider(@NotNull File file, @NotNull List<? extends ProfilerDumpParserProvider> providers) {
        Object v2;
        List noExtension;
        block7: {
            ProfilerDumpParserProvider profilerDumpParserProvider;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            Iterable $this$filterIsInstance$iv = providers;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SignatureBasedProfilerDumpParserProvider)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List providersBySignature = (List)destination$iv$iv;
            try {
                profilerDumpParserProvider = this.findProviderByDumpSignature(file, providersBySignature);
            }
            catch (IOException e) {
                LOG.warn("Exception during checking the file signature; falling back to extension check", (Throwable)e);
                profilerDumpParserProvider = null;
            }
            ProfilerDumpParserProvider providerBySignature = profilerDumpParserProvider;
            if (providerBySignature != null) {
                return new Result.Success(providerBySignature);
            }
            Iterable $this$partition$iv = providers;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ProfilerDumpParserProvider it = (ProfilerDumpParserProvider)element$iv;
                boolean bl = false;
                boolean bl2 = it.getRequiredFileExtension() != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            profilerDumpParserProvider = new Pair(first$iv, second$iv);
            List withExtension = (List)profilerDumpParserProvider.component1();
            noExtension = (List)profilerDumpParserProvider.component2();
            String string = FileUtilRt.getExtension((String)file.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            String extension = string;
            Iterable iterable2 = withExtension;
            for (Object t : iterable2) {
                ProfilerDumpParserProvider it = (ProfilerDumpParserProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRequiredFileExtension(), (Object)extension)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        ProfilerDumpParserProvider providerByExtension = v2;
        if (providerByExtension != null) {
            return new Result.Success(providerByExtension);
        }
        return new Result.Failure(noExtension);
    }

    /*
     * WARNING - void declaration
     */
    private final ProfilerDumpParserProvider findProviderByDumpSignature(File file, List<? extends ProfilerDumpParserProvider> providers) {
        void $this$filterIsInstanceTo$iv$iv;
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        Iterable $this$filterIsInstance$iv = providers;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SignatureBasedProfilerDumpParserProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List providersBySignature = (List)destination$iv$iv;
        ProfilerDumpParserProvider provider = this.findRegularProvider(new FileInputStream(file), providersBySignature);
        if (provider != null) {
            return provider;
        }
        return this.findCompressedProvider(file, providersBySignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProfilerDumpParserProvider findRegularProvider(InputStream inputStream, List<? extends SignatureBasedProfilerDumpParserProvider> providers) {
        Object v7;
        block18: {
            Object object;
            Iterator iterator2 = ((Iterable)providers).iterator();
            if (!iterator2.hasNext()) {
                object = null;
            } else {
                Object p0;
                Object object2;
                Object it = (SignatureBasedProfilerDumpParserProvider)iterator2.next();
                boolean bl = false;
                Iterator iterator3 = ((Iterable)it.getSupportedFileSignatures()).iterator();
                if (!iterator3.hasNext()) {
                    object2 = null;
                } else {
                    p0 = (byte[])iterator3.next();
                    boolean bl2 = false;
                    p0 = ((byte[])p0).length;
                    while (iterator3.hasNext()) {
                        Object p02 = (byte[])iterator3.next();
                        bl3 = false;
                        if (p0.compareTo(p02 = (Object)((byte[])p02).length) >= 0) continue;
                        p0 = p02;
                    }
                    object2 = p0;
                }
                Integer n = (Integer)object2;
                it = n != null ? n : 0;
                while (iterator2.hasNext()) {
                    Object object3;
                    Object it2 = (SignatureBasedProfilerDumpParserProvider)iterator2.next();
                    $i$a$-maxOfOrNull-ProfilerDumpParserProviderFinder$findRegularProvider$maxSignatureLength$1 = false;
                    p0 = ((Iterable)it2.getSupportedFileSignatures()).iterator();
                    if (!p0.hasNext()) {
                        object3 = null;
                    } else {
                        Object p03 = (byte[])p0.next();
                        boolean bl3 = false;
                        p03 = ((byte[])p03).length;
                        while (p0.hasNext()) {
                            Object p04 = (byte[])p0.next();
                            $i$a$-maxOfOrNull-ProfilerDumpParserProviderFinder$findRegularProvider$maxSignatureLength$1$1 = false;
                            if (p03.compareTo(p04 = (Object)((byte[])p04).length) >= 0) continue;
                            p03 = p04;
                        }
                        object3 = p03;
                    }
                    Integer n2 = (Integer)object3;
                    it2 = n2 != null ? n2 : 0;
                    if (it.compareTo(it2) >= 0) continue;
                    it = it2;
                }
                object = it;
            }
            Integer n = (Integer)object;
            int maxSignatureLength = n != null ? n : 0;
            byte[] buffer = new byte[maxSignatureLength];
            Closeable closeable = new DataInputStream(inputStream);
            iterator2 = null;
            try {
                DataInputStream reader = (DataInputStream)closeable;
                boolean bl = false;
                int n3 = reader.readNBytes(buffer, 0, buffer.length);
            }
            catch (Throwable throwable) {
                try {
                    iterator2 = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)closeable, iterator2);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)((Object)iterator2));
            iterator2 = providers;
            Iterator iterator4 = iterator2.iterator();
            while (iterator4.hasNext()) {
                boolean bl;
                Object t;
                block17: {
                    t = iterator4.next();
                    SignatureBasedProfilerDumpParserProvider it = (SignatureBasedProfilerDumpParserProvider)t;
                    boolean bl4 = false;
                    Iterable $this$any$iv = it.getSupportedFileSignatures();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            byte[] sig = (byte[])element$iv;
                            boolean bl5 = false;
                            if (!UtilsKt.isPrefixTo(sig, buffer)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v7 = t;
                break block18;
            }
            v7 = null;
        }
        return v7;
    }

    private final ProfilerDumpParserProvider findCompressedProvider(File file, List<? extends SignatureBasedProfilerDumpParserProvider> providers) {
        CompressedDumpFileParserProviderWrapper compressedDumpFileParserProviderWrapper;
        ProfilerDumpParserProvider provider;
        CompressedDumpDescriptor compressedDumpDescriptor = new CompressedDumpDescriptorFactory().createDescriptorFor(file);
        if (compressedDumpDescriptor == null) {
            return null;
        }
        CompressedDumpDescriptor descriptor = compressedDumpDescriptor;
        InputStream inputStream = descriptor.createUnderlyingSingleFileInputStream();
        if (inputStream == null) {
            return null;
        }
        InputStream compressedStream = inputStream;
        ProfilerDumpParserProvider profilerDumpParserProvider = provider = this.findRegularProvider(compressedStream, providers);
        if (profilerDumpParserProvider != null) {
            ProfilerDumpParserProvider it = profilerDumpParserProvider;
            boolean bl = false;
            compressedDumpFileParserProviderWrapper = new CompressedDumpFileParserProviderWrapper(it, descriptor);
        } else {
            compressedDumpFileParserProviderWrapper = null;
        }
        return compressedDumpFileParserProviderWrapper;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProfilerDumpParserProviderFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result;", "", "<init>", "()V", "Success", "Failure", "Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result$Failure;", "Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result$Success;", "intellij.profiler.common"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result$Failure;", "Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result;", "providersWithoutSignaturesAndExtension", "", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "<init>", "(Ljava/util/List;)V", "getProvidersWithoutSignaturesAndExtension", "()Ljava/util/List;", "intellij.profiler.common"})
        public static final class Failure
        extends Result {
            @NotNull
            private final List<ProfilerDumpParserProvider> providersWithoutSignaturesAndExtension;

            public Failure(@NotNull List<? extends ProfilerDumpParserProvider> providersWithoutSignaturesAndExtension) {
                Intrinsics.checkNotNullParameter(providersWithoutSignaturesAndExtension, (String)"providersWithoutSignaturesAndExtension");
                super(null);
                this.providersWithoutSignaturesAndExtension = providersWithoutSignaturesAndExtension;
            }

            @NotNull
            public final List<ProfilerDumpParserProvider> getProvidersWithoutSignaturesAndExtension() {
                return this.providersWithoutSignaturesAndExtension;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result$Success;", "Lcom/intellij/profiler/ProfilerDumpParserProviderFinder$Result;", "provider", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "<init>", "(Lcom/intellij/profiler/api/ProfilerDumpParserProvider;)V", "getProvider", "()Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "intellij.profiler.common"})
        public static final class Success
        extends Result {
            @NotNull
            private final ProfilerDumpParserProvider provider;

            public Success(@NotNull ProfilerDumpParserProvider provider) {
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                super(null);
                this.provider = provider;
            }

            @NotNull
            public final ProfilerDumpParserProvider getProvider() {
                return this.provider;
            }
        }
    }
}

