/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.diff.DiffUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u0010*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\u0016\b\u0001\u0010\u0003 \u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004:\u0003\u000e\u000f\u0010B\u0017\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00018\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/model/BackStack;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Self", "", "node", "Lcom/intellij/profiler/model/CallTreeNode;", "<init>", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "getNode", "()Lcom/intellij/profiler/model/CallTreeNode;", "parent", "getParent", "()Lcom/intellij/profiler/model/BackStack;", "Regular", "Diff", "Companion", "Lcom/intellij/profiler/model/BackStack$Diff;", "Lcom/intellij/profiler/model/BackStack$Regular;", "intellij.profiler.common"})
abstract class BackStack<Call extends BaseCallStackElement, Self extends BackStack<? extends Call, ? extends Self>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CallTreeNode<Call> node;

    private BackStack(CallTreeNode<? extends Call> node) {
        this.node = node;
    }

    @NotNull
    public final CallTreeNode<Call> getNode() {
        return this.node;
    }

    @Nullable
    public abstract Self getParent();

    public /* synthetic */ BackStack(CallTreeNode node, DefaultConstructorMarker $constructor_marker) {
        this(node);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u0003\u0018\u00010\u0005\"\b\b\u0002\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/model/BackStack$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/profiler/model/BackStack;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "node", "Lcom/intellij/profiler/model/CallTreeNode;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final <Call extends BaseCallStackElement> BackStack<Call, ?> from(@NotNull CallTreeNode<? extends Call> node) {
            BackStack backStack;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            CallTreeNode<? extends Call> callTreeNode = node.getParent();
            if (callTreeNode != null) {
                CallTreeNode<? extends Call> p = callTreeNode;
                boolean bl = false;
                Object Data = node.getData();
                Intrinsics.checkNotNull(Data);
                backStack = (BackStack)DiffUtilsKt.produceDiffDependentValue$default((CallWithValue)Data, arg_0 -> Companion.from$lambda$2$lambda$0(p, arg_0), (arg_0, arg_1) -> Companion.from$lambda$2$lambda$1(p, arg_0, arg_1), null, null, 12, null);
            } else {
                backStack = null;
            }
            return backStack;
        }

        private static final BackStack from$lambda$2$lambda$0(CallTreeNode $p, long it) {
            return new Regular($p, it);
        }

        private static final BackStack from$lambda$2$lambda$1(CallTreeNode $p, long baselineValue, long newValue) {
            return new Diff($p, baselineValue, newValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/model/BackStack$Diff;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/model/BackStack;", "node", "Lcom/intellij/profiler/model/CallTreeNode;", "baselineValue", "", "newValue", "<init>", "(Lcom/intellij/profiler/model/CallTreeNode;JJ)V", "getBaselineValue", "()J", "getNewValue", "parent", "getParent", "()Lcom/intellij/profiler/model/BackStack$Diff;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nRichCallTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RichCallTreeModel.kt\ncom/intellij/profiler/model/BackStack$Diff\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n1#2:475\n*E\n"})
    public static final class Diff<Call extends BaseCallStackElement>
    extends BackStack<Call, Diff<Call>> {
        private final long baselineValue;
        private final long newValue;

        public Diff(@NotNull CallTreeNode<? extends Call> node, long baselineValue, long newValue) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            super(node, null);
            this.baselineValue = baselineValue;
            this.newValue = newValue;
        }

        public final long getBaselineValue() {
            return this.baselineValue;
        }

        public final long getNewValue() {
            return this.newValue;
        }

        @Override
        @Nullable
        public Diff<Call> getParent() {
            Diff diff;
            CallTreeNode callTreeNode = this.getNode().getParent();
            if (callTreeNode != null) {
                CallTreeNode p = callTreeNode;
                boolean bl = false;
                diff = new Diff(p, this.baselineValue, this.newValue);
            } else {
                diff = null;
            }
            return diff;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/model/BackStack$Regular;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/model/BackStack;", "node", "Lcom/intellij/profiler/model/CallTreeNode;", "value", "", "<init>", "(Lcom/intellij/profiler/model/CallTreeNode;J)V", "getValue", "()J", "parent", "getParent", "()Lcom/intellij/profiler/model/BackStack$Regular;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nRichCallTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RichCallTreeModel.kt\ncom/intellij/profiler/model/BackStack$Regular\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n1#2:475\n*E\n"})
    public static final class Regular<Call extends BaseCallStackElement>
    extends BackStack<Call, Regular<Call>> {
        private final long value;

        public Regular(@NotNull CallTreeNode<? extends Call> node, long value) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            super(node, null);
            this.value = value;
        }

        public final long getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Regular<Call> getParent() {
            Regular regular;
            CallTreeNode callTreeNode = this.getNode().getParent();
            if (callTreeNode != null) {
                CallTreeNode p = callTreeNode;
                boolean bl = false;
                regular = new Regular(p, this.value);
            } else {
                regular = null;
            }
            return regular;
        }
    }
}

