/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class TreeExpandedPaths {
    private final List<TreePath> myExpandedPath;
    private final JTree myTree;

    private TreeExpandedPaths(JTree tree, TreePath path) {
        this.myTree = tree;
        this.myExpandedPath = TreeUtil.collectExpandedPaths((JTree)tree, (TreePath)path);
    }

    public static TreeExpandedPaths createOn(JTree tree, TreePath path) {
        return new TreeExpandedPaths(tree, path);
    }

    public TreeExpandedPaths with(TreePath ... somePaths) {
        ContainerUtil.addAll(this.myExpandedPath, (Object[])somePaths);
        return this;
    }

    public TreeExpandedPaths updateAny(TreePathReplacer replacer) {
        for (int i = 0; i < this.myExpandedPath.size(); ++i) {
            TreePath newPath;
            TreePath oldPath = this.myExpandedPath.get(i);
            if (oldPath == (newPath = replacer.replace(oldPath))) continue;
            this.myExpandedPath.set(i, newPath);
        }
        return this;
    }

    public List<TreePath> getPaths() {
        return this.myExpandedPath;
    }

    public int getSize() {
        return this.myExpandedPath.size();
    }

    public static TreePath requireExists(JTree tree, TreePath path) {
        Object[] thePath = path.getPath();
        for (int i = 1; i < thePath.length; ++i) {
            int index = tree.getModel().getIndexOfChild(thePath[i - 1], thePath[i]);
            if (index >= 0) continue;
            throw new IllegalStateException("TreePath is not exists. Fail on " + String.valueOf(thePath[i - 1]) + " and " + String.valueOf(thePath[i]));
        }
        return path;
    }

    @FunctionalInterface
    public static interface TreePathReplacer {
        public TreePath replace(TreePath var1);
    }
}

