/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.search;

import com.intellij.docker.DockerFileSearch;
import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/search/DockerFileSearchImpl;", "Lcom/intellij/docker/DockerFileSearch;", "<init>", "()V", "getDockerFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "promiseDockerFiles", "Lorg/jetbrains/concurrency/CancellablePromise;", "Companion", "intellij.clouds.docker.file"})
public final class DockerFileSearchImpl
extends DockerFileSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Collection<VirtualFile> getDockerFiles(@NotNull Project project) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DumbService.Companion.isDumb(project)) {
            collection = CollectionsKt.emptyList();
        } else if (project.isDefault()) {
            collection = CollectionsKt.emptyList();
        } else {
            Object object = DockerFileSearchImpl.Companion.listDockerFilesAction(project).executeSynchronously();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
            collection = (Collection)object;
        }
        return collection;
    }

    @NotNull
    public CancellablePromise<Collection<VirtualFile>> promiseDockerFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CancellablePromise cancellablePromise = DockerFileSearchImpl.Companion.listDockerFilesAction(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        return cancellablePromise;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/dockerFile/search/DockerFileSearchImpl$Companion;", "", "<init>", "()V", "listDockerFilesAction", "Lcom/intellij/openapi/application/NonBlockingReadAction;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.docker.file"})
    public static final class Companion {
        private Companion() {
        }

        private final NonBlockingReadAction<Collection<VirtualFile>> listDockerFilesAction(Project $this$listDockerFilesAction) {
            NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> Companion.listDockerFilesAction$lambda$0($this$listDockerFilesAction)).inSmartMode($this$listDockerFilesAction);
            Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"inSmartMode(...)");
            return nonBlockingReadAction;
        }

        private static final Collection listDockerFilesAction$lambda$0(Project $this_listDockerFilesAction) {
            return FileTypeIndex.getFiles((FileType)DockerFileType.DOCKER_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)$this_listDockerFilesAction));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

