/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.fileTree;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.fileTree.FileSystemNode;
import com.intellij.docker.ui.fileTree.FileSystemTree;
import com.intellij.docker.ui.fileTree.RemoteFileSystemNodeDescriptor;
import com.intellij.docker.ui.utils.DragAndDropUtilsKt;
import com.intellij.docker.ui.utils.FileTransferable;
import com.intellij.docker.vfs.RemoteFileService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.ide.progress.TasksKt;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/ui/fileTree/DockerFileTreeTransferHandler;", "Ljavax/swing/TransferHandler;", "<init>", "()V", "applicationService", "Lcom/intellij/docker/vfs/RemoteFileService;", "canImport", "", "support", "Ljavax/swing/TransferHandler$TransferSupport;", "createTransferable", "Ljava/awt/datatransfer/Transferable;", "c", "Ljavax/swing/JComponent;", "importData", "getSourceActions", "", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDragAndDrop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragAndDrop.kt\ncom/intellij/docker/ui/fileTree/DockerFileTreeTransferHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,76:1\n40#2,3:77\n*S KotlinDebug\n*F\n+ 1 DragAndDrop.kt\ncom/intellij/docker/ui/fileTree/DockerFileTreeTransferHandler\n*L\n23#1:77,3\n*E\n"})
public final class DockerFileTreeTransferHandler
extends TransferHandler {
    @NotNull
    private final RemoteFileService applicationService;

    public DockerFileTreeTransferHandler() {
        boolean $i$f$service = false;
        Class<RemoteFileService> serviceClass$iv = RemoteFileService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.applicationService = (RemoteFileService)object;
    }

    @Override
    public boolean canImport(@NotNull TransferHandler.TransferSupport support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        return support.isDrop() && support.isDataFlavorSupported(DragAndDropUtilsKt.getFILE_SYSTEM_PATH_FLAVOR());
    }

    @Override
    @NotNull
    protected Transferable createTransferable(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        FileSystemNode selectedNode = ((FileSystemTree)((Object)c)).getSelectedNode();
        return new FileTransferable(selectedNode);
    }

    @Override
    public boolean importData(@NotNull TransferHandler.TransferSupport support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        if (!this.canImport(support)) {
            return false;
        }
        Object object = support.getTransferable().getTransferData(DragAndDropUtilsKt.getFILE_SYSTEM_PATH_FLAVOR());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.ui.fileTree.FileSystemNode");
        FileSystemNode selectedNode = (FileSystemNode)((Object)object);
        TransferHandler.DropLocation dropLocation = support.getDropLocation();
        JTree.DropLocation dropLocation2 = dropLocation instanceof JTree.DropLocation ? (JTree.DropLocation)dropLocation : null;
        if (dropLocation2 == null) {
            DockerFileTreeTransferHandler $this$importData_u24lambda_u240 = this;
            boolean bl = false;
            new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.drop.location.invalid", (Object[])new Object[0]), NotificationType.ERROR).notify(selectedNode.getProject());
            return false;
        }
        JTree.DropLocation dropLocation3 = dropLocation2;
        TreePath treePath = dropLocation3.getPath();
        Object $this$importData_u24lambda_u240 = treePath != null ? treePath.getLastPathComponent() : null;
        DefaultMutableTreeNode defaultMutableTreeNode = $this$importData_u24lambda_u240 instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)$this$importData_u24lambda_u240 : null;
        if (defaultMutableTreeNode == null) {
            return false;
        }
        DefaultMutableTreeNode lastPathComponent = defaultMutableTreeNode;
        Object object2 = lastPathComponent.getUserObject();
        RemoteFileSystemNodeDescriptor remoteFileSystemNodeDescriptor = object2 instanceof RemoteFileSystemNodeDescriptor ? (RemoteFileSystemNodeDescriptor)((Object)object2) : null;
        Object bl = remoteFileSystemNodeDescriptor != null ? remoteFileSystemNodeDescriptor.getElement() : null;
        FileSystemNode fileSystemNode = bl instanceof FileSystemNode ? (FileSystemNode)((Object)bl) : null;
        if (fileSystemNode == null) {
            DockerFileTreeTransferHandler $this$importData_u24lambda_u241 = this;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{""};
            new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.error.occurred.while.moving.file", (Object[])objectArray), NotificationType.ERROR).notify(selectedNode.getProject());
            return false;
        }
        FileSystemNode targetNode = fileSystemNode;
        Component component2 = support.getComponent();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.docker.ui.fileTree.FileSystemTree");
        FileSystemTree fileSystemTree = (FileSystemTree)((Object)component2);
        EelPath newPath = targetNode.getFileTreePath().getPath().resolve(selectedNode.getFileTreePath().getPath().getFileName());
        if (!targetNode.isDirectory() || Intrinsics.areEqual((Object)((Object)targetNode), (Object)((Object)selectedNode)) || Intrinsics.areEqual((Object)newPath, (Object)selectedNode.getFileTreePath().getPath())) {
            return false;
        }
        Project project = fileSystemTree.getProject$intellij_clouds_docker();
        String string = DockerBundle.message((String)"ShowFiles.progress.title.moving.file", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, selectedNode, newPath, fileSystemTree, null){
            int label;
            final /* synthetic */ DockerFileTreeTransferHandler this$0;
            final /* synthetic */ FileSystemNode $selectedNode;
            final /* synthetic */ EelPath $newPath;
            final /* synthetic */ FileSystemTree $fileSystemTree;
            {
                this.this$0 = $receiver;
                this.$selectedNode = $selectedNode;
                this.$newPath = $newPath;
                this.$fileSystemTree = $fileSystemTree;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DockerFileTreeTransferHandler.access$getApplicationService$p(this.this$0).moveFile(this.$selectedNode.getFileTreePath(), this.$newPath, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        v1 = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        v2 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"any(...)");
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)v1.plus(ModalityKt.asContextElement((ModalityState)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$fileSystemTree, null){
                            int label;
                            final /* synthetic */ FileSystemTree $fileSystemTree;
                            {
                                this.$fileSystemTree = $fileSystemTree;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        FileSystemTree.updateTree$default(this.$fileSystemTree, null, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v3 != var4_2) goto lbl24
lbl23:
                        // 1 sources

                        return var4_2;
lbl24:
                        // 1 sources

                        ** GOTO lbl34
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                        }
                        catch (Exception e) {
                            var3_4 = new Object[]{e.getMessage()};
                            new Notification("Docker", DockerBundle.message((String)"ShowFiles.notification.content.error.occurred.while.moving.file", (Object[])var3_4), NotificationType.ERROR).notify(this.$selectedNode.getProject());
                        }
lbl34:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return true;
    }

    @Override
    public int getSourceActions(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return 2;
    }

    public static final /* synthetic */ RemoteFileService access$getApplicationService$p(DockerFileTreeTransferHandler $this) {
        return $this.applicationService;
    }
}

