/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.ui.CellRendererPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class GradientFilledPanel
extends CellRendererPanel {
    private Color myGradientColor;

    public GradientFilledPanel(Color gradientColor) {
        this.myGradientColor = gradientColor;
    }

    public void setGradientColor(Color gradientColor) {
        this.myGradientColor = gradientColor;
    }

    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            if (this.myGradientColor != null && !GraphExportService.getInstance().isPrintMode()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.myGradientColor.brighter(), (float)0.0f, (float)this.getHeight(), (Color)this.myGradientColor));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

