/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"findCommonParent", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "cropToOneLine", "Lcom/intellij/openapi/vfs/VirtualFile;", "textRange", "intellij.platform.duplicatesDetector"})
public final class DuplicateInspectionUtilKt {
    @Nullable
    public static final PsiElement findCommonParent(@NotNull PsiFile file, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PsiElement psiElement = file.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement start2 = psiElement;
        PsiElement psiElement2 = file.findElementAt(range.getEndOffset() - 1);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement end = psiElement2;
        return PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)end);
    }

    @NotNull
    public static final TextRange cropToOneLine(@NotNull VirtualFile file, @NotNull TextRange textRange) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Document document2 = document = FileDocumentManager.getInstance().getDocument(file);
        int endLineOffset = document2 != null ? document2.getLineEndOffset(document.getLineNumber(textRange.getStartOffset())) : textRange.getEndOffset();
        return new TextRange(textRange.getStartOffset(), Math.min(textRange.getEndOffset(), endLineOffset));
    }
}

