/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroupedServersComparer {
    private GroupedServersComparer() {
    }

    public static ComparisonWrapper wrap(final @NotNull WebServerConfig server) {
        if (server == null) {
            GroupedServersComparer.$$$reportNull$$$0(0);
        }
        return new ComparisonWrapper(){

            @Override
            @Nullable
            public String getName() {
                return server.getName();
            }

            @Override
            public boolean isConfigured(@NotNull PublishConfig config, boolean deploymentOnly) {
                if (config == null) {
                    1.$$$reportNull$$$0(0);
                }
                return config.isConfigured(server, deploymentOnly);
            }

            @Override
            public boolean isProjectLevel() {
                return server.isProjectLevel();
            }

            @Override
            public boolean isGroup() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/config/GroupedServersComparer$1", "isConfigured"));
            }
        };
    }

    public static void sortWraps(@NotNull List<WebServerGroupingWrap> wraps, @Nullable PublishConfig publishConfig2) {
        if (wraps == null) {
            GroupedServersComparer.$$$reportNull$$$0(1);
        }
        wraps.sort((o1, o2) -> GroupedServersComparer.compareServers(GroupedServersComparer.wrap(o1), GroupedServersComparer.wrap(o2), publishConfig2));
    }

    public static void sortServers(@NotNull List<WebServerConfig> wraps, @Nullable PublishConfig publishConfig2) {
        if (wraps == null) {
            GroupedServersComparer.$$$reportNull$$$0(2);
        }
        wraps.sort((o1, o2) -> GroupedServersComparer.compareServers(GroupedServersComparer.wrap(o1), GroupedServersComparer.wrap(o2), publishConfig2));
    }

    public static ComparisonWrapper wrap(final @NotNull WebServerGroupingWrap wrap) {
        if (wrap == null) {
            GroupedServersComparer.$$$reportNull$$$0(3);
        }
        return new ComparisonWrapper(){

            @Override
            @NotNull
            public String getName() {
                String string = wrap.getName();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isConfigured(@NotNull PublishConfig config, boolean deploymentOnly) {
                if (config == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (WebServerConfig server : wrap.getServers()) {
                    if (!config.isConfigured(server, deploymentOnly)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean isProjectLevel() {
                return wrap.isProjectLevel();
            }

            @Override
            public boolean isGroup() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/GroupedServersComparer$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/GroupedServersComparer$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isConfigured";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public static int compareServers(@NotNull ComparisonWrapper o1, @NotNull ComparisonWrapper o2, @Nullable PublishConfig config) {
        int compare;
        if (o1 == null) {
            GroupedServersComparer.$$$reportNull$$$0(4);
        }
        if (o2 == null) {
            GroupedServersComparer.$$$reportNull$$$0(5);
        }
        String o1Name = o1.getName();
        String o2Name = o2.getName();
        if (config != null) {
            boolean isConfigured1;
            String defaultServerOrGroupName = config.getDefaultServerOrGroupName();
            if (defaultServerOrGroupName != null) {
                boolean isDefault1 = StringUtil.equals((CharSequence)o1Name, (CharSequence)defaultServerOrGroupName);
                compare = GroupedServersComparer.compare(isDefault1, StringUtil.equals((CharSequence)o2Name, (CharSequence)defaultServerOrGroupName));
                if (compare != 0) {
                    return compare;
                }
                if (isDefault1) {
                    return 0;
                }
            }
            if ((compare = GroupedServersComparer.compare(isConfigured1 = o1.isConfigured(config, false), o2.isConfigured(config, false))) != 0) {
                return compare;
            }
            if (isConfigured1 && (compare = GroupedServersComparer.compare(o1.isConfigured(config, true), o2.isConfigured(config, true))) != 0) {
                return compare;
            }
        }
        if ((compare = GroupedServersComparer.compare(o1.isGroup(), o2.isGroup())) != 0) {
            return compare;
        }
        compare = GroupedServersComparer.compare(o1.isProjectLevel(), o2.isProjectLevel());
        if (compare != 0) {
            return compare;
        }
        return StringUtil.notNullize((String)o1Name).compareToIgnoreCase(StringUtil.notNullize((String)o2Name));
    }

    private static int compare(Boolean value1, Boolean value2) {
        if (value1 != value2) {
            return value1 != false ? -1 : 1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wraps";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/GroupedServersComparer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sortWraps";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sortServers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compareServers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ComparisonWrapper {
        @Nullable
        public String getName();

        public boolean isConfigured(@NotNull PublishConfig var1, boolean var2);

        public boolean isProjectLevel();

        public boolean isGroup();
    }
}

