/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RemoteEditedFileBrowserUrlProvider
extends WebBrowserUrlProvider
implements DumbAware {
    RemoteEditedFileBrowserUrlProvider() {
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            RemoteEditedFileBrowserUrlProvider.$$$reportNull$$$0(0);
        }
        return request.getVirtualFile() instanceof RemoteVirtualFile;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile virtualFile) {
        if (request == null) {
            RemoteEditedFileBrowserUrlProvider.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            RemoteEditedFileBrowserUrlProvider.$$$reportNull$$$0(2);
        }
        PublishConfig publishConfig2 = PublishConfig.getInstance(request.getProject());
        if (!(virtualFile instanceof RemoteVirtualFile)) {
            return null;
        }
        RemoteVirtualFile file = (RemoteVirtualFile)virtualFile;
        Deployable server = file.getServerConfig();
        if (server == null || server.validateUrl() != null) {
            return null;
        }
        Pair<DeploymentPathMapping, Boolean> mapping = publishConfig2.getNearestMappingDeploy2Local(file.getRemotePath(), false, server, true, false, true);
        if (mapping.getFirst() == null) {
            return null;
        }
        String webPath = ((DeploymentPathMapping)mapping.getFirst()).mapToWebPath(file.getRemotePath(), server);
        if (webPath == null) {
            return null;
        }
        String url = DeploymentPathUtils.joinWebPath(server.getUrl(), webPath);
        return url == null ? null : Urls.parseFromIdea((CharSequence)url);
    }

    @Nullable
    public static Url getUrl(@NotNull Project project, @NotNull VirtualFile file) {
        PublishConfig publishConfig2;
        List<WebServerConfig> defaultWrap;
        if (project == null) {
            RemoteEditedFileBrowserUrlProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RemoteEditedFileBrowserUrlProvider.$$$reportNull$$$0(4);
        }
        if ((defaultWrap = (publishConfig2 = PublishConfig.getInstance(project)).findDefaultServers()).isEmpty()) {
            return null;
        }
        for (WebServerConfig server : defaultWrap) {
            String url = publishConfig2.mapToWebPath(file.getPath(), server);
            if (url == null) continue;
            return Urls.parseFromIdea((CharSequence)url);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditedFileBrowserUrlProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandleElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

