/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowManager;

public final class Util {
    public static final long TIMEOUT_INFINITE = -1L;

    private Util() {
    }

    public static void showBalloon(Project project, String toolWindowId, MessageType type, @NlsContexts.NotificationContent String text) {
        ApplicationManager.getApplication().invokeLater(() -> ToolWindowManager.getInstance((Project)project).notifyByBalloon(toolWindowId, type, text));
    }

    public static void showBalloonError(Project project, String toolWindowId, @NlsContexts.NotificationContent String text) {
        Util.showBalloon(project, toolWindowId, MessageType.ERROR, text);
    }

    public static void showBalloonWarning(Project project, String toolWindowId, @NlsContexts.NotificationContent String text) {
        Util.showBalloon(project, toolWindowId, MessageType.WARNING, text);
    }

    public static String getPermissionsAsString(int permissions) {
        return String.valueOf(Util.test(permissions, 256) ? (char)'r' : '-') + (Util.test(permissions, 128) ? (char)'w' : '-') + (Util.test(permissions, 64) ? (char)'x' : '-') + (Util.test(permissions, 32) ? (char)'r' : '-') + (Util.test(permissions, 16) ? (char)'w' : '-') + (Util.test(permissions, 8) ? (char)'x' : '-') + (Util.test(permissions, 4) ? (char)'r' : '-') + (Util.test(permissions, 2) ? (char)'w' : '-') + (Util.test(permissions, 1) ? (char)'x' : '-');
    }

    static String toOctalString(int permissions) {
        return String.format("%03o", permissions);
    }

    public static boolean test(int value, int mask) {
        return (value & mask) == mask;
    }
}

