/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.number.BigFloat;
import org.jetbrains.letsPlot.commons.formatting.number.FormattedNumber;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.commons.formatting.number.SiPrefix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ5\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ5\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/FormatNotationUtil;", "", "()V", "formatDecimalNotation", "Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber;", "number", "Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat;", "precision", "", "formatDecimalNotation$commons", "formatExponentNotation", "minExp", "maxExp", "expType", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "formatExponentNotation$commons", "formatGeneralNotation", "formatGeneralNotation$commons", "formatSiNotation", "formatSiNotation$commons", "commons"})
@SourceDebugExtension(value={"SMAP\nFormatNotationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatNotationUtil.kt\norg/jetbrains/letsPlot/commons/formatting/number/FormatNotationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class FormatNotationUtil {
    @NotNull
    public static final FormatNotationUtil INSTANCE = new FormatNotationUtil();

    private FormatNotationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FormattedNumber formatExponentNotation$commons(@NotNull BigFloat number, int precision, int minExp, int maxExp, @NotNull NumberFormat.ExponentNotationType expType) {
        void it;
        String fraction2;
        String string;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
        if (precision > -1) {
            BigFloat rounded = number.toPrecision(precision);
            Pair<String, String> pair2 = rounded.formatScientificStr(precision);
            String significand = (String)pair2.component1();
            String fraction3 = (String)pair2.component2();
            return new FormattedNumber(significand, fraction3, FormatNotationUtil.formatExponentNotation$buildExponentString(expType, minExp, maxExp, rounded.getExponent()), expType);
        }
        if (Intrinsics.areEqual((Object)number, (Object)BigFloat.Companion.getZERO())) {
            return new FormattedNumber("0", "", "", null, 8, null);
        }
        Pair<String, String> pair3 = number.formatScientificStr(precision);
        String significand = (String)pair3.component1();
        String string2 = string = (fraction2 = (String)pair3.component2());
        String string3 = significand;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)"0");
        String string4 = bl2 ? string : null;
        if (string4 == null) {
            string4 = "";
        }
        NumberFormat.ExponentNotationType exponentNotationType = expType;
        String string5 = FormatNotationUtil.formatExponentNotation$buildExponentString(expType, minExp, maxExp, number.getExponent());
        String string6 = string4;
        String string7 = string3;
        return new FormattedNumber(string7, string6, string5, exponentNotationType);
    }

    @NotNull
    public final FormattedNumber formatSiNotation$commons(@NotNull BigFloat number, int precision) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        int significantDigitsPrecision = Math.max(0, precision - 1);
        BigFloat rounded = number.toPrecision(significantDigitsPrecision);
        SiPrefix siPrefix = NumberFormat.Companion.siPrefixFromExponent$commons(rounded.getExponent());
        BigFloat siScaledNumber = rounded.shiftDecimalPoint(-siPrefix.getBaseExponent());
        int decimalPartPrecision = siScaledNumber.getExponent() >= 0 ? significantDigitsPrecision - siScaledNumber.getWholePartLength() : significantDigitsPrecision;
        return FormattedNumber.copy$default(this.formatDecimalNotation$commons(siScaledNumber, decimalPartPrecision), null, null, siPrefix.getSymbol(), null, 11, null);
    }

    @NotNull
    public final FormattedNumber formatDecimalNotation$commons(@NotNull BigFloat number, int precision) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Pair<String, String> pair2 = number.toDecimalPrecision(precision).formatDecimalStr(precision);
        String integerPart = (String)pair2.component1();
        String d = (String)pair2.component2();
        String fractionalPart = precision <= 0 ? "" : d;
        return new FormattedNumber(integerPart, fractionalPart, null, null, 12, null);
    }

    @NotNull
    public final FormattedNumber formatGeneralNotation$commons(@NotNull BigFloat number, int precision, int minExp, int maxExp, @NotNull NumberFormat.ExponentNotationType expType) {
        FormattedNumber formattedNumber;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
        Integer n = maxExp;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(precision == 0 && it == 0) ? n : null;
        int maxExp2 = n2 != null ? n2 : 1;
        int significantDigitsCount = Math.max(0, precision - 1);
        BigFloat rounded = number.toPrecision(significantDigitsCount);
        if (rounded.getExponent() > minExp && rounded.getExponent() < maxExp2) {
            Pair<String, String> pair2 = rounded.formatDecimalStr(significantDigitsCount - rounded.getExponent());
            String integerPart = (String)pair2.component1();
            String fractionalPart = (String)pair2.component2();
            formattedNumber = new FormattedNumber(integerPart, fractionalPart, null, null, 12, null);
        } else {
            formattedNumber = this.formatExponentNotation$commons(rounded, significantDigitsCount, minExp, maxExp2, expType);
        }
        return formattedNumber;
    }

    private static final String formatExponentNotation$buildExponentString(NumberFormat.ExponentNotationType $expType, int $minExp, int $maxExp, int exp) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$expType.ordinal()]) {
            case 1: {
                string = 'e' + (MathKt.getSign((int)exp) >= 0 ? "+" : "") + exp;
                break;
            }
            case 2: 
            case 3: {
                if (exp == 0 && $minExp < 0 && $maxExp > 0) {
                    string = "";
                    break;
                }
                if (exp == 1 && $minExp < 1 && $maxExp > 1) {
                    string = "\u00b710";
                    break;
                }
                string = "\u00b7\\(10^{" + exp + "}\\)";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NumberFormat.ExponentNotationType.values().length];
            try {
                nArray[NumberFormat.ExponentNotationType.E.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberFormat.ExponentNotationType.POW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberFormat.ExponentNotationType.POW_FULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

