/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.commons.xml.Xml;
import org.jetbrains.letsPlot.core.plot.base.render.text.Hyperlink;
import org.jetbrains.letsPlot.core.plot.base.render.text.Markdown;
import org.jetbrains.letsPlot.core.plot.base.render.text.RichText;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Markdown;", "", "()V", "cssStyle", "", "", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Element;", "getCssStyle", "(Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Element;)Ljava/util/Map;", "parse", "", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "text", "renderRichText", "node", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMarkdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Markdown.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Markdown\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1360#3:84\n1446#3,5:85\n1549#3:90\n1620#3,3:91\n1179#3,2:94\n1253#3,4:96\n*S KotlinDebug\n*F\n+ 1 Markdown.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Markdown\n*L\n67#1:84\n67#1:85,5\n78#1:90\n78#1:91,3\n79#1:94,2\n79#1:96,4\n*E\n"})
public final class Markdown {
    @NotNull
    public static final Markdown INSTANCE = new Markdown();

    private Markdown() {
    }

    @NotNull
    public final List<RichText.RichTextNode> parse(@NotNull String text2) {
        Xml.XmlNode xmlNode;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (((CharSequence)text2).length() == 0) {
            return CollectionsKt.listOf((Object)new RichText.RichTextNode.Text(""));
        }
        String html = org.jetbrains.letsPlot.commons.markdown.Markdown.INSTANCE.mdToHtml(text2);
        Pair<Xml.XmlNode, String> pair2 = Xml.INSTANCE.parseSafe("<p>" + html + "</p>");
        boolean bl = false;
        Xml.XmlNode doc = (Xml.XmlNode)pair2.component1();
        String unparsed = (String)pair2.component2();
        if (((CharSequence)unparsed).length() == 0) {
            xmlNode = doc;
        } else {
            Xml.XmlNode xmlNode2 = doc;
            if (xmlNode2 instanceof Xml.XmlNode.Element) {
                xmlNode = Xml.XmlNode.Element.copy$default((Xml.XmlNode.Element)doc, null, null, CollectionsKt.plus((Collection)((Xml.XmlNode.Element)doc).getChildren(), (Object)new Xml.XmlNode.Text(unparsed)), 3, null);
            } else if (xmlNode2 instanceof Xml.XmlNode.Text) {
                xmlNode = ((Xml.XmlNode.Text)doc).copy(((Xml.XmlNode.Text)doc).getContent() + unparsed);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Xml.XmlNode doc2 = xmlNode;
        return this.renderRichText(doc2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<RichText.RichTextNode> renderRichText(Xml.XmlNode node) {
        block14: {
            block13: {
                output = new ArrayList<E>();
                var3_3 = node;
                if (!(var3_3 instanceof Xml.XmlNode.Text)) break block13;
                ((Collection)output).add(new RichText.RichTextNode.Text(((Xml.XmlNode.Text)node).getContent()));
                break block14;
            }
            if (!(var3_3 instanceof Xml.XmlNode.Element)) break block14;
            if (Intrinsics.areEqual((Object)((Xml.XmlNode.Element)node).getName(), (Object)"a")) {
                v0 = ((Xml.XmlNode.Element)node).getAttributes().get("href");
                if (v0 == null) {
                    v0 = "";
                }
                href = v0;
                text = CollectionsKt.joinToString$default((Iterable)((Xml.XmlNode.Element)node).getChildren(), (CharSequence)"", null, null, (int)0, null, (Function1)renderRichText.text.1.INSTANCE, (int)30, null);
                ((Collection)output).add(new Hyperlink.HyperlinkElement(text, href));
                return output;
            }
            if (Intrinsics.areEqual((Object)((Xml.XmlNode.Element)node).getName(), (Object)"br")) {
                ((Collection)output).add(RichText.RichTextNode.LineBreak.INSTANCE);
                return output;
            }
            if (Intrinsics.areEqual((Object)((Xml.XmlNode.Element)node).getName(), (Object)"softbreak")) {
                ((Collection)output).add(new RichText.RichTextNode.Text(" "));
                return output;
            }
            if (Intrinsics.areEqual((Object)((Xml.XmlNode.Element)node).getName(), (Object)"em")) {
                v1 = TuplesKt.to((Object)RichText.RichTextNode.EmphasisStart.INSTANCE, (Object)RichText.RichTextNode.EmphasisEnd.INSTANCE);
            } else if (Intrinsics.areEqual((Object)((Xml.XmlNode.Element)node).getName(), (Object)"strong")) {
                v1 = TuplesKt.to((Object)RichText.RichTextNode.StrongStart.INSTANCE, (Object)RichText.RichTextNode.StrongEnd.INSTANCE);
            } else if (this.getCssStyle((Xml.XmlNode.Element)node).get("color") != null) {
                v2 = this.getCssStyle((Xml.XmlNode.Element)node).get("color");
                Intrinsics.checkNotNull((Object)v2);
                v1 = TuplesKt.to((Object)new RichText.RichTextNode.ColorStart(Colors.INSTANCE.parseColor(v2)), (Object)RichText.RichTextNode.ColorEnd.INSTANCE);
            } else {
                v1 = text = null;
            }
            if (text == null) ** GOTO lbl-1000
            var8_8 /* !! */  = text;
            $i$a$-let-Markdown$renderRichText$1 = false;
            prefix = (RichText.RichTextNode)var8_8 /* !! */ .component1();
            suffix = (RichText.RichTextNode)var8_8 /* !! */ .component2();
            var6_12 = TuplesKt.to((Object)CollectionsKt.listOf((Object)prefix), (Object)CollectionsKt.listOf((Object)suffix));
            if (var6_12 != null) {
                v3 = var6_12;
            } else lbl-1000:
            // 2 sources

            {
                v3 = new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
            }
            var4_5 = v3;
            prefix = (List)var4_5.component1();
            suffix = (List)var4_5.component2();
            CollectionsKt.addAll((Collection)output, (Iterable)prefix);
            var7_13 = output;
            $this$flatMap$iv = ((Xml.XmlNode.Element)node).getChildren();
            $i$f$flatMap = false;
            prefix = $this$flatMap$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$flatMapTo = false;
            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                p0 = (Xml.XmlNode)element$iv$iv;
                $i$a$-flatMap-Markdown$renderRichText$2 = false;
                list$iv$iv = this.renderRichText(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            var8_8 /* !! */  = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)var7_13, (Iterable)var8_8 /* !! */ );
            CollectionsKt.addAll((Collection)output, (Iterable)suffix);
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getCssStyle(Xml.XmlNode.Element $this$cssStyle) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        String string = $this$cssStyle.getAttributes().get("style");
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String style = string;
        String[] stringArray = new String[]{";"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)style, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, (String)":", null, (int)2, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)it, (String)":", null, (int)2, null))).toString());
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        return destination$iv$iv2;
    }
}

