/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble.tiles;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PositionalScalesUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.tiles.PlotGeomTilesBase;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u001a\u0010\t\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u0016J\u0018\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\t\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/tiles/SimplePlotGeomTiles;", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/tiles/PlotGeomTilesBase;", "geomLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "scalesBeforeFacets", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "mappersNP", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "containsLiveMap", "", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;Z)V", "isSingleTile", "()Z", "getMappersNP", "()Ljava/util/Map;", "scaleXProto", "scaleYProto", "layersByTile", "overallXYContinuousDomains", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "scaleXByTile", "scaleYByTile", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSimplePlotGeomTiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePlotGeomTiles.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/tiles/SimplePlotGeomTiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class SimplePlotGeomTiles
extends PlotGeomTilesBase {
    @NotNull
    private final List<GeomLayer> geomLayers;
    @NotNull
    private final Map<Aes<?>, ScaleMapper<?>> mappersNP;
    @NotNull
    private final Scale scaleXProto;
    @NotNull
    private final Scale scaleYProto;
    private final boolean isSingleTile;

    public SimplePlotGeomTiles(@NotNull List<? extends GeomLayer> geomLayers, @NotNull Map<Aes<?>, ? extends Scale> scalesBeforeFacets, @NotNull Map<Aes<?>, ? extends ScaleMapper<?>> mappersNP, @NotNull CoordProvider coordProvider, boolean containsLiveMap) {
        Intrinsics.checkNotNullParameter(geomLayers, (String)"geomLayers");
        Intrinsics.checkNotNullParameter(scalesBeforeFacets, (String)"scalesBeforeFacets");
        Intrinsics.checkNotNullParameter(mappersNP, (String)"mappersNP");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        super(scalesBeforeFacets, coordProvider, containsLiveMap);
        this.geomLayers = geomLayers;
        this.mappersNP = mappersNP;
        this.scaleXProto = (Scale)MapsKt.getValue(scalesBeforeFacets, Aes.Companion.getX());
        this.scaleYProto = (Scale)MapsKt.getValue(scalesBeforeFacets, Aes.Companion.getY());
        this.isSingleTile = true;
    }

    @Override
    @NotNull
    public Map<Aes<?>, ScaleMapper<?>> getMappersNP() {
        return this.mappersNP;
    }

    @Override
    public boolean isSingleTile() {
        return this.isSingleTile;
    }

    @Override
    @NotNull
    public List<List<GeomLayer>> layersByTile() {
        return CollectionsKt.listOf(this.geomLayers);
    }

    @Override
    @NotNull
    public List<Scale> scaleXByTile() {
        return CollectionsKt.listOf((Object)this.scaleXProto);
    }

    @Override
    @NotNull
    public List<Scale> scaleYByTile() {
        return CollectionsKt.listOf((Object)this.scaleYProto);
    }

    @Override
    @NotNull
    public Pair<DoubleSpan, DoubleSpan> overallXYContinuousDomains() {
        if (!(!this.getContainsLiveMap())) {
            boolean $i$a$-check-SimplePlotGeomTiles$overallXYContinuousDomains$22 = false;
            String $i$a$-check-SimplePlotGeomTiles$overallXYContinuousDomains$22 = "Not applicable to LiveMap.";
            throw new IllegalStateException($i$a$-check-SimplePlotGeomTiles$overallXYContinuousDomains$22.toString());
        }
        List<Pair<DoubleSpan, DoubleSpan>> xyTransformedDomains = PositionalScalesUtil.INSTANCE.computePlotXYTransformedDomains(this.coreLayersByTile(), CollectionsKt.listOf((Object)this.scaleXProto), CollectionsKt.listOf((Object)this.scaleYProto), PlotFacets.Companion.getUNDEFINED(), this.getCoordProvider());
        Pair<DoubleSpan, DoubleSpan> it = xyTransformedDomains.get(0);
        boolean bl = false;
        Transform xTransform = this.scaleXProto.getTransform();
        Transform yTransform = this.scaleYProto.getTransform();
        Pair pair2 = new Pair((Object)(xTransform instanceof ContinuousTransform ? ((ContinuousTransform)xTransform).applyInverse((DoubleSpan)it.getFirst()) : null), yTransform instanceof ContinuousTransform ? ((ContinuousTransform)yTransform).applyInverse((DoubleSpan)it.getSecond()) : null);
        return pair2;
    }
}

