/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.frontend;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.FrontendContext;
import org.jetbrains.letsPlot.GGBunch;
import org.jetbrains.letsPlot.core.util.PlotHtmlHelper;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.intern.figure.SubPlotsFigure;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0006\u0010\u000e\u001a\u00020\u0003J\u001a\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/frontend/NotebookFrontendContext;", "Lorg/jetbrains/letsPlot/FrontendContext;", "jsVersion", "", "isolatedFrame", "", "htmlRenderer", "Lkotlin/Function1;", "", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "display", "plotSpecRaw", "", "", "getConfigureHtml", "getDisplayHtml", "rawSpec", "getHtml", "plotBunch", "Lorg/jetbrains/letsPlot/GGBunch;", "plot", "Lorg/jetbrains/letsPlot/intern/Plot;", "figure", "Lorg/jetbrains/letsPlot/intern/figure/SubPlotsFigure;", "getInfo", "plot-api"})
public final class NotebookFrontendContext
implements FrontendContext {
    @NotNull
    private final String jsVersion;
    private final boolean isolatedFrame;
    @NotNull
    private final Function1<String, Unit> htmlRenderer;

    public NotebookFrontendContext(@NotNull String jsVersion, boolean isolatedFrame, @NotNull Function1<? super String, Unit> htmlRenderer) {
        Intrinsics.checkNotNullParameter((Object)jsVersion, (String)"jsVersion");
        Intrinsics.checkNotNullParameter(htmlRenderer, (String)"htmlRenderer");
        this.jsVersion = jsVersion;
        this.isolatedFrame = isolatedFrame;
        this.htmlRenderer = htmlRenderer;
    }

    @Override
    public void display(@NotNull Map<String, Object> plotSpecRaw) {
        Intrinsics.checkNotNullParameter(plotSpecRaw, (String)"plotSpecRaw");
        String html = PlotHtmlHelper.INSTANCE.getDynamicDisplayHtmlForRawSpec(plotSpecRaw);
        this.htmlRenderer.invoke((Object)html);
    }

    @Override
    @NotNull
    public String getInfo() {
        return "Notebook with " + (this.isolatedFrame ? "static HTML in output" : "dynamically loaded JS") + ". Lets-Plot JS v." + this.jsVersion + '.';
    }

    @NotNull
    public final String getConfigureHtml() {
        return this.isolatedFrame ? "" : PlotHtmlHelper.INSTANCE.getDynamicConfigureHtml(PlotHtmlHelper.INSTANCE.scriptUrl(this.jsVersion), false);
    }

    @NotNull
    public final String getHtml(@NotNull Plot plot) {
        Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
        return this.getDisplayHtml(ToSpecConvertersKt.toSpec(plot));
    }

    @NotNull
    public final String getHtml(@NotNull SubPlotsFigure figure) {
        Intrinsics.checkNotNullParameter((Object)figure, (String)"figure");
        return this.getDisplayHtml(figure.toSpec());
    }

    @NotNull
    public final String getHtml(@NotNull GGBunch plotBunch) {
        Intrinsics.checkNotNullParameter((Object)plotBunch, (String)"plotBunch");
        return this.getDisplayHtml(plotBunch.toSpec());
    }

    @NotNull
    public final String getDisplayHtml(@NotNull Map<String, Object> rawSpec) {
        Intrinsics.checkNotNullParameter(rawSpec, (String)"rawSpec");
        return this.isolatedFrame ? StringsKt.trimIndent((String)("\n            " + PlotHtmlHelper.INSTANCE.getStaticConfigureHtml(PlotHtmlHelper.INSTANCE.scriptUrl(this.jsVersion)) + "    \n            " + PlotHtmlHelper.getStaticDisplayHtmlForRawSpec$default(PlotHtmlHelper.INSTANCE, rawSpec, null, false, false, 14, null) + "    \n            ")) : PlotHtmlHelper.INSTANCE.getDynamicDisplayHtmlForRawSpec(rawSpec);
    }
}

