/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0006J\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkBKGD;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "blue", "", "gray", "green", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "paletteIndex", "rGB", "", "getRGB", "()[I", "red", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "getGray", "getPaletteIndex", "parseFromRaw", "", "chunk", "setGray", "setPaletteIndex", "i", "setRGB", "r", "g", "b", "Companion", "plot-api"})
public final class PngChunkBKGD
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int paletteIndex;
    @NotNull
    public static final String ID = "bKGD";

    public PngChunkBKGD(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = null;
        if (this.getImgInfo().getGreyscale()) {
            c = this.createEmptyChunk(2, true);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.gray, c.getData(), 0);
        } else if (this.getImgInfo().getIndexed()) {
            c = this.createEmptyChunk(1, true);
            byte[] byArray = c.getData();
            Intrinsics.checkNotNull((Object)byArray);
            byArray[0] = (byte)this.paletteIndex;
        } else {
            c = this.createEmptyChunk(6, true);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.red, c.getData(), 0);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.green, c.getData(), 0);
            PngHelperInternal.INSTANCE.writeInt2tobytes(this.blue, c.getData(), 0);
        }
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.getImgInfo().getGreyscale()) {
            this.gray = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), 0);
        } else if (this.getImgInfo().getIndexed()) {
            byte[] byArray = chunk.getData();
            Intrinsics.checkNotNull((Object)byArray);
            this.paletteIndex = byArray[0] & 0xFF;
        } else {
            this.red = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), 0);
            this.green = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), 2);
            this.blue = PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), 4);
        }
    }

    public final void setGray(int gray) {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only gray images support this");
        }
        this.gray = gray;
    }

    public final int getGray() {
        if (!this.getImgInfo().getGreyscale()) {
            throw new PngjException("only gray images support this");
        }
        return this.gray;
    }

    public final void setPaletteIndex(int i) {
        if (!this.getImgInfo().getIndexed()) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        this.paletteIndex = i;
    }

    public final int getPaletteIndex() {
        if (!this.getImgInfo().getIndexed()) {
            throw new PngjException("only indexed (pallete) images support this");
        }
        return this.paletteIndex;
    }

    public final void setRGB(int r, int g, int b2) {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.red = r;
        this.green = g;
        this.blue = b2;
    }

    @NotNull
    public final int[] getRGB() {
        if (this.getImgInfo().getGreyscale() || this.getImgInfo().getIndexed()) {
            throw new PngjException("only rgb or rgba images support this");
        }
        int[] nArray = new int[]{this.red, this.green, this.blue};
        return nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkBKGD$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

