/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMAnimatedTransformList;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMElement;
import org.jetbrains.relocated.apache.batik.bridge.AnimatableSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.BridgeUpdateHandler;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.ErrorConstants;
import org.jetbrains.relocated.apache.batik.bridge.GenericBridge;
import org.jetbrains.relocated.apache.batik.bridge.GraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.SVGSwitchElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.bridge.UnitProcessor;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngineEvent;
import org.jetbrains.relocated.apache.batik.css.engine.SVGCSSEngine;
import org.jetbrains.relocated.apache.batik.dom.events.AbstractEvent;
import org.jetbrains.relocated.apache.batik.dom.svg.AbstractSVGTransformList;
import org.jetbrains.relocated.apache.batik.dom.svg.LiveAttributeException;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGContext;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGMotionAnimatableElement;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.SegmentList;
import org.jetbrains.relocated.apache.batik.gvt.CanvasGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.CompositeGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGTransformable;

public abstract class AbstractGraphicsNodeBridge
extends AnimatableSVGBridge
implements SVGContext,
BridgeUpdateHandler,
GraphicsNodeBridge,
ErrorConstants {
    protected GraphicsNode node;
    protected boolean isSVG12;
    protected UnitProcessor.Context unitContext;
    protected SoftReference bboxShape = null;
    protected Rectangle2D bbox = null;

    protected AbstractGraphicsNodeBridge() {
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx2, Element e) {
        if (!SVGUtilities.matchUserAgent(e, ctx2.getUserAgent())) {
            return null;
        }
        GraphicsNode node = this.instantiateGraphicsNode();
        this.setTransform(node, e, ctx2);
        node.setVisible(CSSUtilities.convertVisibility(e));
        this.associateSVGContext(ctx2, e, node);
        return node;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    @Override
    public void buildGraphicsNode(BridgeContext ctx2, Element e, GraphicsNode node) {
        node.setComposite(CSSUtilities.convertOpacity(e));
        node.setFilter(CSSUtilities.convertFilter(e, node, ctx2));
        node.setMask(CSSUtilities.convertMask(e, node, ctx2));
        node.setClip(CSSUtilities.convertClipPath(e, node, ctx2));
        node.setPointerEventType(CSSUtilities.convertPointerEvents(e));
        this.initializeDynamicSupport(ctx2, e, node);
    }

    @Override
    public boolean getDisplay(Element e) {
        return CSSUtilities.convertDisplay(e);
    }

    protected AffineTransform computeTransform(SVGTransformable te, BridgeContext ctx2) {
        try {
            SVGMotionAnimatableElement mae;
            AffineTransform mat;
            AffineTransform at = new AffineTransform();
            SVGOMAnimatedTransformList atl = (SVGOMAnimatedTransformList)te.getTransform();
            if (atl.isSpecified()) {
                atl.check();
                AbstractSVGTransformList tl = (AbstractSVGTransformList)te.getTransform().getAnimVal();
                at.concatenate(tl.getAffineTransform());
            }
            if (this.e instanceof SVGMotionAnimatableElement && (mat = (mae = (SVGMotionAnimatableElement)((Object)this.e)).getMotionTransform()) != null) {
                at.concatenate(mat);
            }
            return at;
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx2, ex);
        }
    }

    protected void setTransform(GraphicsNode n, Element e, BridgeContext ctx2) {
        n.setTransform(this.computeTransform((SVGTransformable)e, ctx2));
    }

    protected void associateSVGContext(BridgeContext ctx2, Element e, GraphicsNode node) {
        this.e = e;
        this.node = node;
        this.ctx = ctx2;
        this.unitContext = UnitProcessor.createContext(ctx2, e);
        this.isSVG12 = ctx2.isSVG12();
        ((SVGOMElement)e).setSVGContext(this);
    }

    protected void initializeDynamicSupport(BridgeContext ctx2, Element e, GraphicsNode node) {
        if (ctx2.isInteractive()) {
            ctx2.bind(e, node);
        }
    }

    @Override
    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
    }

    protected void handleGeometryChanged() {
        this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
        this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
        this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
        if (this.isSVG12) {
            if (!"use".equals(this.e.getLocalName())) {
                this.fireShapeChangeEvent();
            }
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireShapeChangeEvent() {
        DocumentEvent d = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent evt = (AbstractEvent)d.createEvent("SVGEvents");
        evt.initEventNS("http://www.w3.org/2000/svg", "shapechange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent(evt);
        }
        catch (RuntimeException ex) {
            this.ctx.getUserAgent().displayError(ex);
        }
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        Element e2;
        Bridge b2;
        if (evt.getTarget() instanceof Element && (b2 = this.ctx.getBridge(e2 = (Element)((Object)evt.getTarget()))) instanceof GenericBridge) {
            ((GenericBridge)b2).handleElement(this.ctx, e2);
        }
    }

    @Override
    public void handleDOMNodeRemovedEvent(MutationEvent evt) {
        SVGContext bridge;
        Node parent = this.e.getParentNode();
        if (parent instanceof SVGOMElement && (bridge = ((SVGOMElement)parent).getSVGContext()) instanceof SVGSwitchElementBridge) {
            ((SVGSwitchElementBridge)bridge).handleChildElementRemoved(this.e);
            return;
        }
        CompositeGraphicsNode gn = this.node.getParent();
        gn.remove(this.node);
        AbstractGraphicsNodeBridge.disposeTree(this.e);
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent evt) {
    }

    @Override
    public void dispose() {
        SVGOMElement elt = (SVGOMElement)this.e;
        elt.setSVGContext(null);
        this.ctx.unbind(this.e);
        this.bboxShape = null;
    }

    protected static void disposeTree(Node node) {
        AbstractGraphicsNodeBridge.disposeTree(node, true);
    }

    protected static void disposeTree(Node node, boolean removeContext) {
        SVGOMElement elt;
        SVGContext ctx2;
        if (node instanceof SVGOMElement && (ctx2 = (elt = (SVGOMElement)node).getSVGContext()) instanceof BridgeUpdateHandler) {
            BridgeUpdateHandler h = (BridgeUpdateHandler)((Object)ctx2);
            if (removeContext) {
                elt.setSVGContext(null);
            }
            h.dispose();
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            AbstractGraphicsNodeBridge.disposeTree(n, removeContext);
        }
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent evt) {
        try {
            int[] properties;
            SVGCSSEngine eng = (SVGCSSEngine)evt.getSource();
            for (int idx : properties = evt.getProperties()) {
                this.handleCSSPropertyChanged(idx);
                String pn = eng.getPropertyName(idx);
                this.fireBaseAttributeListeners(pn);
            }
        }
        catch (Exception ex) {
            this.ctx.getUserAgent().displayError(ex);
        }
    }

    protected void handleCSSPropertyChanged(int property2) {
        switch (property2) {
            case 57: {
                this.node.setVisible(CSSUtilities.convertVisibility(this.e));
                break;
            }
            case 38: {
                this.node.setComposite(CSSUtilities.convertOpacity(this.e));
                break;
            }
            case 18: {
                this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
                break;
            }
            case 37: {
                this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
                break;
            }
            case 3: {
                this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
                break;
            }
            case 40: {
                this.node.setPointerEventType(CSSUtilities.convertPointerEvents(this.e));
                break;
            }
            case 12: {
                if (this.getDisplay(this.e)) break;
                CompositeGraphicsNode parent = this.node.getParent();
                parent.remove(this.node);
                AbstractGraphicsNodeBridge.disposeTree(this.e, false);
            }
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        if (alav.getNamespaceURI() == null && alav.getLocalName().equals("transform")) {
            this.setTransform(this.node, this.e, this.ctx);
            this.handleGeometryChanged();
        }
    }

    @Override
    public void handleOtherAnimationChanged(String type) {
        if (type.equals("motion")) {
            this.setTransform(this.node, this.e, this.ctx);
            this.handleGeometryChanged();
        }
    }

    protected void checkBBoxChange() {
        if (this.e != null) {
            this.fireBBoxChangeEvent();
        }
    }

    protected void fireBBoxChangeEvent() {
        DocumentEvent d = (DocumentEvent)((Object)this.e.getOwnerDocument());
        AbstractEvent evt = (AbstractEvent)d.createEvent("SVGEvents");
        evt.initEventNS("http://www.w3.org/2000/svg", "RenderedBBoxChange", true, false);
        try {
            ((EventTarget)((Object)this.e)).dispatchEvent(evt);
        }
        catch (RuntimeException ex) {
            this.ctx.getUserAgent().displayError(ex);
        }
    }

    @Override
    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    @Override
    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    @Override
    public Rectangle2D getBBox() {
        if (this.node == null) {
            return null;
        }
        Shape s = this.node.getOutline();
        if (this.bboxShape != null && s == this.bboxShape.get()) {
            return this.bbox;
        }
        this.bboxShape = new SoftReference<Shape>(s);
        this.bbox = null;
        if (s == null) {
            return this.bbox;
        }
        SegmentList sl = new SegmentList(s);
        this.bbox = sl.getBounds2D();
        return this.bbox;
    }

    @Override
    public AffineTransform getCTM() {
        GraphicsNode gn = this.node;
        AffineTransform ctm = new AffineTransform();
        Element elt = this.e;
        while (elt != null) {
            AffineTransform at;
            if (elt instanceof SVGFitToViewBox) {
                at = gn instanceof CanvasGraphicsNode ? ((CanvasGraphicsNode)gn).getViewingTransform() : gn.getTransform();
                if (at == null) break;
                ctm.preConcatenate(at);
                break;
            }
            at = gn.getTransform();
            if (at != null) {
                ctm.preConcatenate(at);
            }
            elt = SVGCSSEngine.getParentCSSStylableElement(elt);
            gn = gn.getParent();
        }
        return ctm;
    }

    @Override
    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    @Override
    public void setScreenTransform(AffineTransform at) {
        this.ctx.getUserAgent().setTransform(at);
    }

    @Override
    public AffineTransform getGlobalTransform() {
        return this.node.getGlobalTransform();
    }

    @Override
    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.e);
    }

    @Override
    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.e);
    }

    @Override
    public float getFontSize() {
        return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
    }
}

