/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.DocumentBridge;
import org.jetbrains.relocated.apache.batik.bridge.GenericBridge;
import org.jetbrains.relocated.apache.batik.bridge.GraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.InterruptedBridgeException;
import org.jetbrains.relocated.apache.batik.gvt.CompositeGraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.RootGraphicsNode;
import org.jetbrains.relocated.apache.batik.util.HaltingThread;
import org.jetbrains.relocated.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext ctx2, Document document) {
        ctx2.setDocument(document);
        ctx2.initializeDocument(document);
        ctx2.setGVTBuilder(this);
        DocumentBridge dBridge = ctx2.getDocumentBridge();
        RootGraphicsNode rootNode = null;
        try {
            rootNode = dBridge.createGraphicsNode(ctx2, document);
            Element svgElement = document.getDocumentElement();
            GraphicsNode topNode = null;
            Bridge bridge = ctx2.getBridge(svgElement);
            if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
            topNode = gnBridge.createGraphicsNode(ctx2, svgElement);
            if (topNode == null) {
                return null;
            }
            rootNode.getChildren().add(topNode);
            this.buildComposite(ctx2, svgElement, (CompositeGraphicsNode)topNode);
            gnBridge.buildGraphicsNode(ctx2, svgElement, topNode);
            dBridge.buildGraphicsNode(ctx2, document, rootNode);
        }
        catch (BridgeException ex) {
            ex.setGraphicsNode(rootNode);
            throw ex;
        }
        if (ctx2.isInteractive()) {
            ctx2.addUIEventListeners(document);
            ctx2.addGVTListener(document);
        }
        if (ctx2.isDynamic()) {
            ctx2.addDOMListeners();
        }
        return rootNode;
    }

    public GraphicsNode build(BridgeContext ctx2, Element e) {
        Bridge bridge = ctx2.getBridge(e);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx2, e);
            this.handleGenericBridges(ctx2, e);
            return null;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(ctx2, e);
            return null;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        if (!gnBridge.getDisplay(e)) {
            this.handleGenericBridges(ctx2, e);
            return null;
        }
        GraphicsNode gn = gnBridge.createGraphicsNode(ctx2, e);
        if (gn != null) {
            if (gnBridge.isComposite()) {
                this.buildComposite(ctx2, e, (CompositeGraphicsNode)gn);
            } else {
                this.handleGenericBridges(ctx2, e);
            }
            gnBridge.buildGraphicsNode(ctx2, e, gn);
        }
        if (ctx2.isDynamic()) {
            // empty if block
        }
        return gn;
    }

    protected void buildComposite(BridgeContext ctx2, Element e, CompositeGraphicsNode parentNode) {
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.buildGraphicsNode(ctx2, (Element)n, parentNode);
        }
    }

    protected void buildGraphicsNode(BridgeContext ctx2, Element e, CompositeGraphicsNode parentNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = ctx2.getBridge(e);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx2, e);
            this.handleGenericBridges(ctx2, e);
            return;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(ctx2, e);
            return;
        }
        if (!CSSUtilities.convertDisplay(e)) {
            this.handleGenericBridges(ctx2, e);
            return;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        try {
            GraphicsNode gn = gnBridge.createGraphicsNode(ctx2, e);
            if (gn != null) {
                parentNode.getChildren().add(gn);
                if (gnBridge.isComposite()) {
                    this.buildComposite(ctx2, e, (CompositeGraphicsNode)gn);
                } else {
                    this.handleGenericBridges(ctx2, e);
                }
                gnBridge.buildGraphicsNode(ctx2, e, gn);
            } else {
                this.handleGenericBridges(ctx2, e);
            }
        }
        catch (BridgeException ex) {
            GraphicsNode errNode = ex.getGraphicsNode();
            if (errNode != null) {
                parentNode.getChildren().add(errNode);
                gnBridge.buildGraphicsNode(ctx2, e, errNode);
                ex.setGraphicsNode(null);
            }
            throw ex;
        }
    }

    protected void handleGenericBridges(BridgeContext ctx2, Element e) {
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            Element e2 = (Element)n;
            Bridge b2 = ctx2.getBridge(e2);
            if (b2 instanceof GenericBridge) {
                ((GenericBridge)b2).handleElement(ctx2, e2);
            }
            this.handleGenericBridges(ctx2, e2);
        }
    }
}

