/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.generator.IndexChunkInfo;
import com.intellij.indexing.shared.generator.IndexesExporterIOResult;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.io.PathKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a\b\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u0015"}, d2={"chunkNamePrefix", "", "chunk", "Lcom/intellij/indexing/shared/generator/IndexChunkInfo;", "deliverToOutputDir", "Lcom/intellij/indexing/shared/generator/IndexesExporterIOResult;", "indexFile", "Ljava/nio/file/Path;", "metadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "prefix", "ext", "outputDir", "addSha256ToOutputNames", "", "ensureVfsInitialized", "", "specifyLineup", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "lineup", "Lcom/intellij/indexing/shared/download/SharedIndexLineup;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporter.kt\ncom/intellij/indexing/shared/generator/IndexesExporterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1563#2:196\n1634#2,3:197\n774#2:200\n865#2,2:201\n*S KotlinDebug\n*F\n+ 1 IndexesExporter.kt\ncom/intellij/indexing/shared/generator/IndexesExporterKt\n*L\n38#1:196\n38#1:197,3\n39#1:200\n39#1:201,2\n*E\n"})
public final class IndexesExporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String chunkNamePrefix(@NotNull IndexChunkInfo chunk) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Object[] objectArray = new String[]{"shared", "index", chunk.getKind(), chunk.getName()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null) + "-";
    }

    @NotNull
    public static final IndexesExporterIOResult deliverToOutputDir(@NotNull Path indexFile, @NotNull SharedIndexMetadata metadata, @NotNull String prefix, @NotNull String ext, @NotNull Path outputDir, boolean addSha256ToOutputNames) {
        Intrinsics.checkNotNullParameter((Object)indexFile, (String)"indexFile");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        String sha = DigestUtilKt.sha256Hex((Path)indexFile);
        String targetFileName = addSha256ToOutputNames ? prefix + StringsKt.take((String)sha, (int)16) : prefix;
        Path path = outputDir.resolve(targetFileName + ext);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = outputDir.resolve(targetFileName + ".sha256");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = outputDir.resolve(targetFileName + ".metadata.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        IndexesExporterIOResult result = new IndexesExporterIOResult(path, path2, path3, sha);
        PathKt.createDirectories((Path)outputDir);
        Object object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(indexFile, result.getIndexPath(), (CopyOption[])object);
        Path path4 = result.getSha256Path();
        object = sha;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(path4, byArray, new OpenOption[0]);
        SharedIndexMetadata.Companion.writeAsJson$default((SharedIndexMetadata.Companion)SharedIndexMetadata.Companion, (SharedIndexMetadata)metadata, (Path)result.getMetadataPath(), (boolean)false, (int)2, null);
        return result;
    }

    private static final void ensureVfsInitialized() {
        PersistentFS.getInstance();
    }

    @NotNull
    public static final SharedIndexMetadataInfo specifyLineup(@NotNull SharedIndexMetadataInfo $this$specifyLineup, @Nullable SharedIndexLineup lineup) {
        Intrinsics.checkNotNullParameter((Object)$this$specifyLineup, (String)"<this>");
        return SharedIndexMetadataInfo.copy$default((SharedIndexMetadataInfo)$this$specifyLineup, null, null, null, null, null, null, null, (SharedIndexLineup)lineup, (int)127, null);
    }

    public static final /* synthetic */ void access$ensureVfsInitialized() {
        IndexesExporterKt.ensureVfsInitialized();
    }
}

