create package Roll
as
    procedure pl (s string);
    procedure line;
end Roll;
/

create or replace package body Roll
as


    procedure pl(s string)
    is
    begin
        line;  sys.dbms_output.put_line(s); line;
    end;



    procedure line
    is 
    begin
    	for i in 1..80 
    		loop
    			dbms_output.put('-');
  		end loop; 
  	dbms_output.put_line('');	
    end;
    
    
end Roll;
/


declare
    x natural := 0;
    y natural := 0;
begin
    --
    for r in (select * from dual) loop
        y := y + 7;
    end loop;
    --
    while (1 is null) loop x := 1; end loop;
    while (2 is null) loop x := 2; y := 3; end loop;
    --
    while (42 is not null) loop
            -- comment at the begin
            x := x + 1;
            y := y + 2;
            -- comment in the middle
            x := y - x;
            y := y - x;
            -- comment at the end
        end loop;
    --
end;
/



begin
    Roll.pl('Test before wrapping');
end;
/

declare
    text varchar(900) := '';
    prepared_text varcahr(1200) := '';
begin
    text := sys.dbms_metadata.get_ddl('PACKAGE_BODY', 'ROLL', user);
    prepared_text := trim(replace(text, 'EDITIONABLE', ''));
    --sys.dbms_output.put_line(prepared_text);
    sys.dbms_ddl.create_wrapped(prepared_text);
end;
/

alter package Roll compile body
/

begin
    Roll.pl('Test after wrapping');
end;
/