"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ReporterUtils = /** @class */ (function () {
    function ReporterUtils() {
    }
    ReporterUtils.isAttributeValueEscapingNeeded = function (str) {
        var len = str.length;
        for (var i = 0; i < len; i++) {
            if (ReporterUtils.doEscapeCharCode(str.charCodeAt(i))) {
                return true;
            }
        }
        return false;
    };
    ReporterUtils.escapeAttributeValue = function (value) {
        if (value == null) {
            return value;
        }
        var str = String(value);
        if (!ReporterUtils.isAttributeValueEscapingNeeded(str)) {
            return str;
        }
        var res = '', len = str.length;
        for (var i = 0; i < len; i++) {
            var escaped = ReporterUtils.doEscapeCharCode(str.charCodeAt(i));
            if (escaped) {
                res += '|';
                res += escaped;
            }
            else {
                res += str.charAt(i);
            }
        }
        return res;
    };
    ReporterUtils.doEscapeCharCode = (function () {
        var obj = {};
        function addMapping(fromChar, toChar) {
            if (fromChar.length !== 1 || toChar.length !== 1) {
                throw Error('String length should be 1');
            }
            var fromCharCode = fromChar.charCodeAt(0);
            if (typeof obj[fromCharCode] === 'undefined') {
                obj[fromCharCode] = toChar;
            }
            else {
                throw Error('Bad mapping');
            }
        }
        addMapping('\n', 'n');
        addMapping('\r', 'r');
        addMapping('\u0085', 'x');
        addMapping('\u2028', 'l');
        addMapping('\u2029', 'p');
        addMapping('|', '|');
        addMapping('\'', '\'');
        addMapping('[', '[');
        addMapping(']', ']');
        return function (charCode) {
            return obj[charCode];
        };
    }());
    return ReporterUtils;
}());
exports.default = ReporterUtils;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0ZXJVdGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlL3JlcG9ydGVyVXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTtJQUFBO0lBZ0VBLENBQUM7SUFoQ2dCLDRDQUE4QixHQUE3QyxVQUE4QyxHQUFXO1FBQ3ZELElBQU0sR0FBRyxHQUFHLEdBQUcsQ0FBQyxNQUFNLENBQUE7UUFDdEIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEdBQUcsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUM1QixJQUFJLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ3JELE9BQU8sSUFBSSxDQUFDO2FBQ2I7U0FDRjtRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUVhLGtDQUFvQixHQUFsQyxVQUFtQyxLQUFhO1FBQzlDLElBQUksS0FBSyxJQUFJLElBQUksRUFBRTtZQUNqQixPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsSUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFBO1FBQ3pCLElBQUksQ0FBQyxhQUFhLENBQUMsOEJBQThCLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDdEQsT0FBTyxHQUFHLENBQUM7U0FDWjtRQUNELElBQUksR0FBRyxHQUFHLEVBQUUsRUFBRSxHQUFHLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQTtRQUU5QixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsR0FBRyxFQUFFLENBQUMsRUFBRSxFQUFFO1lBQzVCLElBQU0sT0FBTyxHQUFHLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUE7WUFDakUsSUFBSSxPQUFPLEVBQUU7Z0JBQ1gsR0FBRyxJQUFJLEdBQUcsQ0FBQztnQkFDWCxHQUFHLElBQUksT0FBTyxDQUFDO2FBQ2hCO2lCQUNJO2dCQUNILEdBQUcsSUFBSSxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQ3RCO1NBQ0Y7UUFDRCxPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7SUE5RGMsOEJBQWdCLEdBQXNCLENBQUM7UUFDcEQsSUFBTSxHQUFHLEdBQUcsRUFBRSxDQUFBO1FBRWQsU0FBUyxVQUFVLENBQUMsUUFBZ0IsRUFBRSxNQUFjO1lBQ2xELElBQUksUUFBUSxDQUFDLE1BQU0sS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7Z0JBQ2hELE1BQU0sS0FBSyxDQUFDLDJCQUEyQixDQUFDLENBQUM7YUFDMUM7WUFDRCxJQUFNLFlBQVksR0FBRyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFBO1lBQzNDLElBQUksT0FBTyxHQUFHLENBQUMsWUFBWSxDQUFDLEtBQUssV0FBVyxFQUFFO2dCQUM1QyxHQUFHLENBQUMsWUFBWSxDQUFDLEdBQUcsTUFBTSxDQUFDO2FBQzVCO2lCQUNJO2dCQUNILE1BQU0sS0FBSyxDQUFDLGFBQWEsQ0FBQyxDQUFDO2FBQzVCO1FBQ0gsQ0FBQztRQUVELFVBQVUsQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdEIsVUFBVSxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQztRQUN0QixVQUFVLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQzFCLFVBQVUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDMUIsVUFBVSxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUMxQixVQUFVLENBQUMsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBQ3JCLFVBQVUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDdkIsVUFBVSxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUNyQixVQUFVLENBQUMsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRXJCLE9BQU8sVUFBVSxRQUFRO1lBQ3ZCLE9BQU8sR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3ZCLENBQUMsQ0FBQztJQUNKLENBQUMsRUFBRSxDQUFDLENBQUM7SUFrQ1Asb0JBQUM7Q0FBQSxBQWhFRCxJQWdFQztrQkFoRTZCLGFBQWEiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZGVmYXVsdCBhYnN0cmFjdCBjbGFzcyBSZXBvcnRlclV0aWxzIHtcbiAgcHJpdmF0ZSBzdGF0aWMgZG9Fc2NhcGVDaGFyQ29kZTogKGNoYXJDb2RlKSA9PiBhbnkgPSAoZnVuY3Rpb24gKCkge1xuICAgIGNvbnN0IG9iaiA9IHt9XG5cbiAgICBmdW5jdGlvbiBhZGRNYXBwaW5nKGZyb21DaGFyOiBzdHJpbmcsIHRvQ2hhcjogc3RyaW5nKTogdm9pZCB7XG4gICAgICBpZiAoZnJvbUNoYXIubGVuZ3RoICE9PSAxIHx8IHRvQ2hhci5sZW5ndGggIT09IDEpIHtcbiAgICAgICAgdGhyb3cgRXJyb3IoJ1N0cmluZyBsZW5ndGggc2hvdWxkIGJlIDEnKTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGZyb21DaGFyQ29kZSA9IGZyb21DaGFyLmNoYXJDb2RlQXQoMClcbiAgICAgIGlmICh0eXBlb2Ygb2JqW2Zyb21DaGFyQ29kZV0gPT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgIG9ialtmcm9tQ2hhckNvZGVdID0gdG9DaGFyO1xuICAgICAgfVxuICAgICAgZWxzZSB7XG4gICAgICAgIHRocm93IEVycm9yKCdCYWQgbWFwcGluZycpO1xuICAgICAgfVxuICAgIH1cblxuICAgIGFkZE1hcHBpbmcoJ1xcbicsICduJyk7XG4gICAgYWRkTWFwcGluZygnXFxyJywgJ3InKTtcbiAgICBhZGRNYXBwaW5nKCdcXHUwMDg1JywgJ3gnKTtcbiAgICBhZGRNYXBwaW5nKCdcXHUyMDI4JywgJ2wnKTtcbiAgICBhZGRNYXBwaW5nKCdcXHUyMDI5JywgJ3AnKTtcbiAgICBhZGRNYXBwaW5nKCd8JywgJ3wnKTtcbiAgICBhZGRNYXBwaW5nKCdcXCcnLCAnXFwnJyk7XG4gICAgYWRkTWFwcGluZygnWycsICdbJyk7XG4gICAgYWRkTWFwcGluZygnXScsICddJyk7XG5cbiAgICByZXR1cm4gZnVuY3Rpb24gKGNoYXJDb2RlKSB7XG4gICAgICByZXR1cm4gb2JqW2NoYXJDb2RlXTtcbiAgICB9O1xuICB9KCkpO1xuXG4gIHByaXZhdGUgc3RhdGljIGlzQXR0cmlidXRlVmFsdWVFc2NhcGluZ05lZWRlZChzdHI6IHN0cmluZyk6IGJvb2xlYW4ge1xuICAgIGNvbnN0IGxlbiA9IHN0ci5sZW5ndGhcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IGxlbjsgaSsrKSB7XG4gICAgICBpZiAoUmVwb3J0ZXJVdGlscy5kb0VzY2FwZUNoYXJDb2RlKHN0ci5jaGFyQ29kZUF0KGkpKSkge1xuICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBlc2NhcGVBdHRyaWJ1dGVWYWx1ZSh2YWx1ZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICBpZiAodmFsdWUgPT0gbnVsbCkge1xuICAgICAgcmV0dXJuIHZhbHVlO1xuICAgIH1cbiAgICBjb25zdCBzdHIgPSBTdHJpbmcodmFsdWUpXG4gICAgaWYgKCFSZXBvcnRlclV0aWxzLmlzQXR0cmlidXRlVmFsdWVFc2NhcGluZ05lZWRlZChzdHIpKSB7XG4gICAgICByZXR1cm4gc3RyO1xuICAgIH1cbiAgICBsZXQgcmVzID0gJycsIGxlbiA9IHN0ci5sZW5ndGhcblxuICAgIGZvciAobGV0IGkgPSAwOyBpIDwgbGVuOyBpKyspIHtcbiAgICAgIGNvbnN0IGVzY2FwZWQgPSBSZXBvcnRlclV0aWxzLmRvRXNjYXBlQ2hhckNvZGUoc3RyLmNoYXJDb2RlQXQoaSkpXG4gICAgICBpZiAoZXNjYXBlZCkge1xuICAgICAgICByZXMgKz0gJ3wnO1xuICAgICAgICByZXMgKz0gZXNjYXBlZDtcbiAgICAgIH1cbiAgICAgIGVsc2Uge1xuICAgICAgICByZXMgKz0gc3RyLmNoYXJBdChpKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHJlcztcbiAgfVxufSJdfQ==