function HttpClient(global) {
  this.global = new Variables(global)

  this.log = __log
}

function Body(elementsProvider) {
  this.__raw = elementsProvider.getRawBody()
  this.__substituted = elementsProvider.getSubstitutedBody()

  this.getRaw = function getRaw() {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstituted = function tryGetSubstituted() {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}

function Environment(elementsProvider) {
  this.__env = elementsProvider

  this.get = function get(name) {
    return __null_aware_to_string(this.__env.getEnvironmentVariable(name))
  }
}

function Header(header) {
  this.name = __null_aware_to_string(header.name)
  this.__raw = header.getRawValue()
  this.__substituted = header.getSubstitutedValue()

  this.getRawValue = function getRawValue() {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstitutedValue = function tryGetSubstitutedValue() {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}

function Headers(provider) {
  this.__headers = provider.getHeaders()

  this.all = function all() {
    const iterator = this.__headers.getValue().iterator()
    const result = []
    while (iterator.hasNext()) {
      let h = iterator.next()
      result.push(new Header(h))
    }
    return result
  }

  this.findByName = function findByName(name) {
    const result = this.__headers.getValue().getHeader(name)
    return result !== null ? new Header(result) : null
  }
}

function Url(elementsProvider) {
  this.__raw = elementsProvider.getRawUrl()
  this.__substituted = elementsProvider.getSubstitutedUrl()

  this.getRaw = function getRaw() {
    return __null_aware_to_string(this.__raw.getValue())
  }

  this.tryGetSubstituted = function tryGetSubstituted() {
    return __null_aware_to_string(this.__substituted.getValue())
  }
}

function Digest(delegate) {
  this.toBase64 = function toBase64(urlSafe) {
    return __null_aware_to_string(delegate.toBase64(!!(urlSafe || false)))
  }

  this.toHex = function toHex() {
    return __null_aware_to_string(delegate.toHex())
  }
}

function DigestBuilder(delegate) {
  this.updateWithText = function updateWithText(message, encoding) {
    delegate.updateWithText(message, encoding || null)
    return this
  }

  this.updateWithHex = function updateWithHex(hex) {
    delegate.updateWithHex(hex)
    return this
  }

  this.updateWithBase64 = function updateWithBase64(base64Text, urlSafe) {
    delegate.updateWithBase64(base64Text, !!(urlSafe || false))
    return this
  }

  this.digest = function digest() {
    return new Digest(delegate.digest())
  }
}

function HmacSupport(delegate) {
  this.sha1 = function sha1() {
    return new HmacInitializer(delegate.sha1())
  }

  this.sha256 = function sha256() {
    return new HmacInitializer(delegate.sha256())
  }

  this.sha512 = function sha512() {
    return new HmacInitializer(delegate.sha512())
  }

  this.sha384 = function sha384() {
    return new HmacInitializer(delegate.sha384())
  }

  this.md5 = function md5() {
    return new HmacInitializer(delegate.md5())
  }
}

function HmacInitializer(delegate) {
  this.withTextSecret = function withTextSecret(secret, encoding) {
    return new DigestBuilder(delegate.withTextSecret(secret, encoding || null))
  }

  this.withHexSecret = function withHexSecret(hex) {
    return new DigestBuilder(delegate.withHexSecret(hex))
  }

  this.withBase64Secret = function withBase64Secret(base64Secret, urlSafe) {
    return new DigestBuilder(delegate.withBase64Secret(base64Secret, !!(urlSafe || false)))
  }
}

function Crypto(delegate) {
  this.hmac = new HmacSupport(delegate.hmacSupport())

  this.sha1 = function sha1() {
    return new DigestBuilder(delegate.sha1())
  }

  this.sha256 = function sha256() {
    return new DigestBuilder(delegate.sha256())
  }

  this.sha512 = function sha512() {
    return new DigestBuilder(delegate.sha512())
  }

  this.sha384 = function sha384() {
    return new DigestBuilder(delegate.sha384())
  }

  this.md5 = function md5() {
    return new DigestBuilder(delegate.md5())
  }
}

const client = new HttpClient(__args.global)

function Request(requestElementsProvider) {
  this.variables = new Variables([])
  this.body = new Body(requestElementsProvider)
  this.url = new Url(requestElementsProvider)
  this.headers = new Headers(requestElementsProvider)
  this.environment = new Environment(requestElementsProvider)
  this.method = '' + requestElementsProvider.getMethod()

  this.iteration = function() {
    return requestElementsProvider.iteration()
  }

  this.templateValue = function (number) {
    return requestElementsProvider.templateValue(number)
  }
}

const request = new Request(__args.requestElementsProvider);
const crypto = new Crypto(__args.cryptoSupport)