"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Example = exports.MessageExample = void 0;
var react_1 = __importStar(require("react"));
var components_1 = require("../../components");
var message_1 = require("../../helpers/message");
var contexts_1 = require("../../contexts");
var MessageExample = function (_a) {
    var message = _a.message;
    if (!message) {
        return null;
    }
    var payload = message.payload();
    var headers = message.headers();
    return (react_1.default.createElement("div", { className: "bg-gray-800 px-8 py-4 mt-4 -mx-8 2xl:mx-0 2xl:px-4 2xl:rounded examples" },
        react_1.default.createElement("h4", { className: "text-white text-lg" }, "Examples"),
        payload && (react_1.default.createElement(exports.Example, { type: "Payload", schema: payload, examples: message_1.MessageHelpers.getPayloadExamples(message) })),
        headers && (react_1.default.createElement(exports.Example, { type: "Headers", schema: headers, examples: message_1.MessageHelpers.getHeadersExamples(message) }))));
};
exports.MessageExample = MessageExample;
var Example = function (_a) {
    var _b, _c;
    var _d = _a.type, type = _d === void 0 ? 'Payload' : _d, schema = _a.schema, _e = _a.examples, examples = _e === void 0 ? [] : _e;
    var config = (0, contexts_1.useConfig)();
    var _f = (0, react_1.useState)((_c = (_b = config === null || config === void 0 ? void 0 : config.expand) === null || _b === void 0 ? void 0 : _b.messageExamples) !== null && _c !== void 0 ? _c : false), expanded = _f[0], setExpanded = _f[1];
    (0, react_1.useEffect)(function () {
        var _a, _b;
        setExpanded((_b = (_a = config === null || config === void 0 ? void 0 : config.expand) === null || _a === void 0 ? void 0 : _a.messageExamples) !== null && _b !== void 0 ? _b : false);
    }, [config.expand]);
    return (react_1.default.createElement("div", { className: "mt-4" },
        react_1.default.createElement("div", null,
            react_1.default.createElement(components_1.CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded, chevronProps: {
                    className: 'fill-current text-gray-200',
                } },
                react_1.default.createElement("span", { className: "inline-block w-20 py-0.5 mr-1 text-gray-200 text-sm border text-center rounded focus:outline-none" }, type))),
        react_1.default.createElement("div", { className: expanded ? 'block' : 'hidden' }, examples && examples.length > 0 ? (react_1.default.createElement("ul", null, examples.map(function (example, idx) { return (react_1.default.createElement("li", { className: "mt-4", key: idx },
            react_1.default.createElement("h5", { className: "text-xs font-bold text-gray-500" }, example.name
                ? "#".concat(idx + 1, " Example - ").concat(example.name)
                : "#".concat(idx + 1, " Example")),
            example.summary && (react_1.default.createElement("p", { className: "text-xs font-bold text-gray-500" }, example.summary)),
            react_1.default.createElement("div", { className: "mt-1" },
                react_1.default.createElement(components_1.JSONSnippet, { snippet: message_1.MessageHelpers.sanitizeExample(example.example) })))); }))) : (react_1.default.createElement("div", { className: "mt-4" },
            react_1.default.createElement(components_1.JSONSnippet, { snippet: message_1.MessageHelpers.generateExample(schema.json()) }),
            react_1.default.createElement("h6", { className: "text-xs font-bold text-gray-600 italic mt-2" }, "This example has been generated automatically."))))));
};
exports.Example = Example;
//# sourceMappingURL=MessageExample.js.map