"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sidebar = void 0;
var react_1 = __importStar(require("react"));
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var sidebar_1 = require("../../helpers/sidebar");
var SidebarContext = react_1.default.createContext({
    setShowSidebar: function (value) { return value; },
});
var Sidebar = function () {
    var _a, _b, _c;
    var _d = (0, react_1.useState)(false), showSidebar = _d[0], setShowSidebar = _d[1];
    var asyncapi = (0, contexts_1.useSpec)();
    var config = (0, contexts_1.useConfig)();
    var info = asyncapi.info();
    var logo = (_a = info.extensions().get('x-logo')) === null || _a === void 0 ? void 0 : _a.value();
    var components = asyncapi.components();
    var messages = components === null || components === void 0 ? void 0 : components.messages().all();
    var schemas = components === null || components === void 0 ? void 0 : components.schemas().all();
    var hasOperations = asyncapi.operations().length > 0;
    var showMessages = (_b = config.show) === null || _b === void 0 ? void 0 : _b.messages;
    var showSchemas = (_c = config.show) === null || _c === void 0 ? void 0 : _c.schemas;
    var messagesList = (messages === null || messages === void 0 ? void 0 : messages.length) > 0 && (react_1.default.createElement("li", { className: "mb-3 mt-9" },
        react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#messages", onClick: function () { return setShowSidebar(false); } }, "Messages"),
        react_1.default.createElement("ul", { className: "text-sm mt-2" }, messages.map(function (message, index) {
            var _a, _b;
            return (react_1.default.createElement("li", { key: "menu-message-list-".concat((_a = message.name()) !== null && _a !== void 0 ? _a : index) },
                react_1.default.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#message-".concat((_b = message.name()) !== null && _b !== void 0 ? _b : message.id()), onClick: function () { return setShowSidebar(false); } },
                    react_1.default.createElement("div", { className: "break-all inline-block" }, message.id()))));
        }))));
    var schemasList = (schemas === null || schemas === void 0 ? void 0 : schemas.length) > 0 && (react_1.default.createElement("li", { className: "mb-3 mt-9" },
        react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#schemas", onClick: function () { return setShowSidebar(false); } }, "Schemas"),
        react_1.default.createElement("ul", { className: "text-sm mt-2" }, schemas.map(function (schema, index) {
            var _a;
            return (react_1.default.createElement("li", { key: "menu-message-list-".concat((_a = schema.id()) !== null && _a !== void 0 ? _a : index) },
                react_1.default.createElement("a", { className: "flex break-words no-underline text-gray-700 mt-2 hover:text-gray-900", href: "#schema-".concat(schema.id()), onClick: function () { return setShowSidebar(false); } },
                    react_1.default.createElement("div", { className: "break-all inline-block" }, schema.id()))));
        }))));
    var operationList = hasOperations && (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("li", { className: "mb-3 mt-9" },
            react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#operations", onClick: function () { return setShowSidebar(false); } }, "Operations"),
            react_1.default.createElement(OperationsList, null)),
        showMessages && messagesList,
        showSchemas && schemasList));
    return (react_1.default.createElement(SidebarContext.Provider, { value: { setShowSidebar: setShowSidebar } },
        react_1.default.createElement("div", { className: "burger-menu rounded-full h-16 w-16 bg-white fixed bottom-16 right-8 flex items-center justify-center z-30 cursor-pointer shadow-md bg-teal-500", onClick: function () { return setShowSidebar(function (prev) { return !prev; }); }, "data-lol": showSidebar },
            react_1.default.createElement("svg", { viewBox: "0 0 100 70", width: "40", height: "30", className: "fill-current text-gray-200" },
                react_1.default.createElement("rect", { width: "100", height: "10" }),
                react_1.default.createElement("rect", { y: "30", width: "100", height: "10" }),
                react_1.default.createElement("rect", { y: "60", width: "100", height: "10" }))),
        react_1.default.createElement("div", { className: "".concat(showSidebar ? 'block fixed w-full' : 'hidden', " sidebar relative w-64 max-h-screen h-full bg-gray-200 shadow z-20") },
            react_1.default.createElement("div", { className: "".concat(showSidebar ? 'sidebar--wrapper' : '', " block fixed max-h-screen h-full font-sans px-4 pt-8 pb-16 overflow-y-auto bg-gray-200") },
                react_1.default.createElement("div", { className: "sidebar--content" },
                    react_1.default.createElement("div", null, logo ? (react_1.default.createElement("img", { src: logo, alt: "".concat(info.title(), " logo, ").concat(info.version(), " version") })) : (react_1.default.createElement("h1", { className: "text-2xl font-light" },
                        info.title(),
                        " ",
                        info.version()))),
                    react_1.default.createElement("ul", { className: "text-sm mt-10 relative" },
                        react_1.default.createElement("li", { className: "mb-3" },
                            react_1.default.createElement("a", { className: "text-gray-700 no-underline hover:text-gray-900", href: "#introduction", onClick: function () { return setShowSidebar(false); } }, "Introduction")),
                        asyncapi.servers().length > 0 && (react_1.default.createElement("li", { className: "mb-3 mt-9" },
                            react_1.default.createElement("a", { className: "text-xs uppercase text-gray-700 mt-10 mb-4 font-thin hover:text-gray-900", href: "#servers", onClick: function () { return setShowSidebar(false); } }, "Servers"),
                            react_1.default.createElement(ServersList, null))),
                        operationList))))));
};
exports.Sidebar = Sidebar;
var ServersList = function () {
    var _a, _b;
    var sidebarConfig = (0, contexts_1.useConfig)().sidebar;
    var asyncapi = (0, contexts_1.useSpec)();
    var servers = asyncapi.servers().all();
    var showServers = (_a = sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showServers) !== null && _a !== void 0 ? _a : 'byDefault';
    if (showServers === 'byDefault') {
        return (react_1.default.createElement("ul", { className: "text-sm mt-2" }, servers.map(function (server) { return (react_1.default.createElement(ServerItem, { serverName: server.id(), key: server.id() })); })));
    }
    var specTagNames;
    if (showServers === 'bySpecTags') {
        specTagNames = ((_b = asyncapi.info().tags().all()) !== null && _b !== void 0 ? _b : []).map(function (tag) {
            return tag.name();
        });
    }
    else {
        var serverTagNamesSet_1 = new Set();
        servers.forEach(function (server) {
            server.tags().forEach(function (t) { return serverTagNamesSet_1.add(t.name()); });
        });
        specTagNames = Array.from(serverTagNamesSet_1);
    }
    var serializedServers = servers.map(function (server) { return ({
        name: server.id(),
        tags: server.tags(),
        data: {},
    }); });
    var _c = (0, sidebar_1.filterObjectsByTags)(specTagNames, serializedServers), tagged = _c.tagged, untagged = _c.untagged;
    return (react_1.default.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedServers = _a[1];
            return (react_1.default.createElement("li", { key: tag },
                react_1.default.createElement(ItemsByTagItem, { tagName: tag }, taggedServers.map(function (_a) {
                    var serverName = _a.name;
                    return (react_1.default.createElement(ServerItem, { serverName: serverName, key: serverName }));
                }))));
        }),
        untagged.length > 0 ? (react_1.default.createElement("li", null,
            react_1.default.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var serverName = _a.name;
                return (react_1.default.createElement(ServerItem, { serverName: serverName, key: serverName }));
            })))) : null));
};
var OperationsList = function () {
    var _a, _b;
    var config = (0, contexts_1.useConfig)();
    var sidebarConfig = config.sidebar;
    var asyncapi = (0, contexts_1.useSpec)();
    var operations = asyncapi.operations().all();
    var showOperations = (_a = sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.showOperations) !== null && _a !== void 0 ? _a : 'byDefault';
    var processedOperations = operations.map(function (operation) {
        var _a, _b, _c;
        var operationChannel = operation.channels();
        var operationHrefId = helpers_1.CommonHelpers.getOperationIdentifier({
            operation: operation,
            config: config,
        });
        var type = helpers_1.CommonHelpers.getOperationType(operation);
        var specV = asyncapi.version();
        var version = specV.localeCompare('2.6.0', undefined, {
            numeric: true,
        });
        var label = '';
        if (version === 0 || (sidebarConfig === null || sidebarConfig === void 0 ? void 0 : sidebarConfig.useChannelAddressAsIdentifier)) {
            var operationChannels = operationChannel.all();
            var channelAddress = (_b = (_a = operationChannels[0]) === null || _a === void 0 ? void 0 : _a.address()) !== null && _b !== void 0 ? _b : '';
            var operationSummary = operation.summary();
            label = operationSummary !== null && operationSummary !== void 0 ? operationSummary : channelAddress;
        }
        else {
            label = (_c = operation.id()) !== null && _c !== void 0 ? _c : '';
        }
        return {
            name: "".concat(type, "-").concat(operation.id()),
            tags: operation.tags(),
            data: {
                label: label,
                type: type,
                operationHrefId: operationHrefId,
            },
        };
    });
    if (showOperations === 'byDefault') {
        return (react_1.default.createElement("ul", { className: "text-sm mt-2" }, processedOperations.map(function (_a) {
            var name = _a.name, data = _a.data;
            return (react_1.default.createElement(OperationItem, __assign({ key: name }, data)));
        })));
    }
    var operationTagNames;
    if (showOperations === 'bySpecTags') {
        operationTagNames = ((_b = asyncapi.info().tags().all()) !== null && _b !== void 0 ? _b : []).map(function (tag) {
            return tag.name();
        });
    }
    else {
        var operationTagNamesSet_1 = new Set();
        operations.forEach(function (operation) {
            operation
                .tags()
                .all()
                .forEach(function (t) { return operationTagNamesSet_1.add(t.name()); });
        });
        operationTagNames = Array.from(operationTagNamesSet_1);
    }
    var _c = (0, sidebar_1.filterObjectsByTags)(operationTagNames, processedOperations), tagged = _c.tagged, untagged = _c.untagged;
    return (react_1.default.createElement("ul", { className: "text-sm mt-2" },
        Array.from(tagged.entries()).map(function (_a) {
            var tag = _a[0], taggedOperations = _a[1];
            return (react_1.default.createElement("li", { key: tag },
                react_1.default.createElement(ItemsByTagItem, { tagName: tag }, taggedOperations.map(function (_a) {
                    var name = _a.name, data = _a.data;
                    return (react_1.default.createElement(OperationItem, __assign({ key: name }, data)));
                }))));
        }),
        untagged.length > 0 ? (react_1.default.createElement("li", null,
            react_1.default.createElement(ItemsByTagItem, { tagName: "Untagged" }, untagged.map(function (_a) {
                var name = _a.name, data = _a.data;
                return (react_1.default.createElement(OperationItem, __assign({ key: name }, data)));
            })))) : null));
};
var OperationItem = function (_a) {
    var type = _a.type, operationHrefId = _a.operationHrefId, label = _a.label;
    var config = (0, contexts_1.useConfig)();
    var setShowSidebar = (0, react_1.useContext)(SidebarContext).setShowSidebar;
    var specV = (0, contexts_1.useSpec)().version();
    var version = specV.localeCompare('2.6.0', undefined, { numeric: true });
    var isAsyncAPIv2 = version === 0;
    var _b = helpers_1.CommonHelpers.getOperationDesignInformation({
        type: type,
        config: config,
        isAsyncAPIv2: isAsyncAPIv2,
    }), typeLabel = _b.typeLabel, backgroundColor = _b.backgroundColor;
    var bgColors = [
        'bg-red-600',
        'bg-orange-600',
        'bg-green-600',
        'bg-blue-600',
    ];
    return (react_1.default.createElement("li", { key: "menu-operation-list-".concat(operationHrefId) },
        react_1.default.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#".concat(operationHrefId), onClick: function () { return setShowSidebar(false); } },
            react_1.default.createElement("strong", { className: "h-6 no-underline text-white uppercase p-1 mr-2 rounded text-xs ".concat(bgColors.includes(backgroundColor) && backgroundColor), title: typeLabel }, typeLabel),
            react_1.default.createElement("span", { className: "break-all inline-block" }, label))));
};
var ServerItem = function (_a) {
    var serverName = _a.serverName;
    var setShowSidebar = (0, react_1.useContext)(SidebarContext).setShowSidebar;
    return (react_1.default.createElement("li", null,
        react_1.default.createElement("a", { className: "flex no-underline text-gray-700 mb-2 hover:text-gray-900", href: "#server-".concat(serverName), onClick: function () { return setShowSidebar(false); } },
            react_1.default.createElement("span", { className: "break-all inline-block" }, serverName))));
};
var ItemsByTagItem = function (_a) {
    var tagName = _a.tagName, children = _a.children;
    var _b = (0, react_1.useState)(false), expand = _b[0], setExpand = _b[1];
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(components_1.CollapseButton, { onClick: function () { return setExpand(function (prev) { return !prev; }); }, chevronProps: {
                className: expand ? '-rotate-180' : '-rotate-90',
            } },
            react_1.default.createElement("span", { className: "text-sm inline-block mt-1 font-extralight" }, tagName)),
        react_1.default.createElement("ul", { className: "".concat(expand ? 'block' : 'hidden', " text-sm mt-2 font-light") }, children)));
};
//# sourceMappingURL=Sidebar.js.map