/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.ModbusFailureCallback;
import org.openhab.core.io.transport.modbus.ModbusReadCallback;
import org.openhab.core.io.transport.modbus.ModbusReadRequestBlueprint;
import org.openhab.core.io.transport.modbus.PollTask;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpoint;

@NonNullByDefault
public class BasicPollTask
implements PollTask {
    private ModbusSlaveEndpoint endpoint;
    private ModbusReadRequestBlueprint request;
    private ModbusReadCallback resultCallback;
    private ModbusFailureCallback<ModbusReadRequestBlueprint> failureCallback;

    public BasicPollTask(ModbusSlaveEndpoint endpoint, ModbusReadRequestBlueprint request, ModbusReadCallback resultCallback, ModbusFailureCallback<ModbusReadRequestBlueprint> failureCallback) {
        this.endpoint = endpoint;
        this.request = request;
        this.resultCallback = resultCallback;
        this.failureCallback = failureCallback;
    }

    @Override
    public ModbusReadRequestBlueprint getRequest() {
        return this.request;
    }

    @Override
    public ModbusSlaveEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ModbusReadCallback getResultCallback() {
        return this.resultCallback;
    }

    @Override
    public ModbusFailureCallback<ModbusReadRequestBlueprint> getFailureCallback() {
        return this.failureCallback;
    }

    public int hashCode() {
        return Objects.hash(this.request, this.getEndpoint(), this.getResultCallback(), this.getFailureCallback());
    }

    public String toString() {
        return "BasicPollTask [getEndpoint=" + String.valueOf(this.getEndpoint()) + ", request=" + String.valueOf(this.request) + ", getResultCallback()=" + String.valueOf(this.getResultCallback()) + ", getFailureCallback()=" + String.valueOf(this.getFailureCallback()) + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BasicPollTask rhs = (BasicPollTask)obj;
        return Objects.equals(this.request, rhs.request) && Objects.equals(this.getEndpoint(), rhs.getEndpoint()) && Objects.equals(this.getResultCallback(), rhs.getResultCallback()) && Objects.equals(this.getFailureCallback(), rhs.getFailureCallback());
    }
}

