/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.action;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.action.BusEvent;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={BusEvent.class})
@NonNullByDefault
public class BusEventImpl
implements BusEvent {
    private static final String AUTOMATION_SOURCE = "org.openhab.core.automation.module.script";
    private final Logger logger = LoggerFactory.getLogger(BusEventImpl.class);
    private final ItemRegistry itemRegistry;
    private final EventPublisher publisher;

    @Activate
    public BusEventImpl(@Reference ItemRegistry itemRegistry, @Reference EventPublisher publisher) {
        this.itemRegistry = itemRegistry;
        this.publisher = publisher;
    }

    @Override
    public void sendCommand(Item item, String commandString) {
        if (item != null) {
            this.sendCommand(item.getName(), commandString);
        }
    }

    @Override
    public void sendCommand(Item item, String commandString, @Nullable String source) {
        if (item != null) {
            this.sendCommand(item.getName(), commandString, source);
        }
    }

    @Override
    public void sendCommand(Item item, Number command) {
        this.sendCommand(item, command, null);
    }

    @Override
    public void sendCommand(Item item, Number command, @Nullable String source) {
        if (item != null && command != null) {
            this.sendCommand(item.getName(), command.toString(), source);
        }
    }

    @Override
    public void sendCommand(String itemName, String commandString) {
        this.sendCommand(itemName, commandString, null);
    }

    @Override
    public void sendCommand(String itemName, String commandString, @Nullable String source) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandString);
            if (command != null) {
                this.publisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command, (String)this.buildSource(source)));
            } else {
                this.logger.warn("Cannot convert '{}' to a command type which item '{}' accepts: {}.", new Object[]{commandString, itemName, BusEventImpl.getAcceptedCommandNames(item)});
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Item '{}' does not exist.", (Object)itemName);
        }
    }

    private static <T extends State> List<String> getAcceptedCommandNames(Item item) {
        return item.getAcceptedCommandTypes().stream().map(Class::getSimpleName).toList();
    }

    @Override
    public void sendCommand(Item item, Command command) {
        this.sendCommand(item, command, null);
    }

    @Override
    public void sendCommand(Item item, Command command, @Nullable String source) {
        if (item != null) {
            this.publisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command, (String)this.buildSource(source)));
        }
    }

    @Override
    public void postUpdate(Item item, String stateString) {
        this.postUpdate(item, stateString, null);
    }

    @Override
    public void postUpdate(Item item, String stateString, @Nullable String source) {
        if (item != null) {
            this.postUpdate(item.getName(), stateString, source);
        }
    }

    @Override
    public void postUpdate(Item item, Number state) {
        this.postUpdate(item, state, null);
    }

    @Override
    public void postUpdate(Item item, Number state, @Nullable String source) {
        if (item != null && state != null) {
            this.postUpdate(item.getName(), state.toString(), source);
        }
    }

    private static <T extends State> List<String> getAcceptedDataTypeNames(Item item) {
        return item.getAcceptedDataTypes().stream().map(Class::getSimpleName).toList();
    }

    @Override
    public void postUpdate(String itemName, String stateString) {
        this.postUpdate(itemName, stateString, null);
    }

    @Override
    public void postUpdate(String itemName, String stateString, @Nullable String source) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
            if (state != null) {
                this.publisher.post((Event)ItemEventFactory.createStateEvent((String)itemName, (State)state, (String)this.buildSource(source)));
            } else {
                this.logger.warn("Cannot convert '{}' to a state type which item '{}' accepts: {}.", new Object[]{stateString, itemName, BusEventImpl.getAcceptedDataTypeNames(item)});
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Item '{}' does not exist.", (Object)itemName);
        }
    }

    @Override
    public void postUpdate(Item item, State state) {
        this.postUpdate(item, state, null);
    }

    @Override
    public void postUpdate(Item item, State state, @Nullable String source) {
        if (item != null) {
            this.publisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state, (String)this.buildSource(source)));
        }
    }

    @Override
    public void sendTimeSeries(@Nullable Item item, @Nullable TimeSeries timeSeries) {
        this.sendTimeSeries(item, timeSeries, null);
    }

    @Override
    public void sendTimeSeries(@Nullable Item item, @Nullable TimeSeries timeSeries, @Nullable String source) {
        if (item != null && timeSeries != null) {
            this.publisher.post((Event)ItemEventFactory.createTimeSeriesEvent((String)item.getName(), (TimeSeries)timeSeries, (String)this.buildSource(source)));
        }
    }

    @Override
    public void sendTimeSeries(@Nullable String itemName, @Nullable Map<ZonedDateTime, State> values, String policy) {
        this.sendTimeSeries(itemName, values, policy, null);
    }

    @Override
    public void sendTimeSeries(@Nullable String itemName, @Nullable Map<ZonedDateTime, State> values, String policy, @Nullable String source) {
        if (itemName != null && values != null) {
            try {
                TimeSeries timeSeries = new TimeSeries(TimeSeries.Policy.valueOf((String)policy));
                values.forEach((key, value) -> timeSeries.add(key.toInstant(), value));
                this.publisher.post((Event)ItemEventFactory.createTimeSeriesEvent((String)itemName, (TimeSeries)timeSeries, (String)this.buildSource(source)));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Policy '{}' does not exist.", (Object)policy);
            }
        }
    }

    @Override
    public Map<Item, State> storeStates(Item ... items) {
        HashMap<Item, State> statesMap = new HashMap<Item, State>();
        if (items != null) {
            Item[] itemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getAllMembers()) {
                        statesMap.put(member, member.getState());
                    }
                } else {
                    statesMap.put(item, item.getState());
                }
                ++n2;
            }
        }
        return statesMap;
    }

    @Override
    public void restoreStates(Map<Item, State> statesMap) {
        if (statesMap != null) {
            for (Map.Entry<Item, State> entry : statesMap.entrySet()) {
                if (entry.getValue() instanceof Command) {
                    this.sendCommand(entry.getKey(), (Command)entry.getValue());
                    continue;
                }
                this.postUpdate(entry.getKey(), entry.getValue());
            }
        }
    }

    private String buildSource(@Nullable String source) {
        return Objects.requireNonNullElse(source, AUTOMATION_SOURCE);
    }
}

