/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

public final class Preconditions {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static <T> T checkNotNullFromProvides(T reference) {
        if (reference == null) {
            throw new NullPointerException("Cannot return null from a non-@Nullable @Provides method");
        }
        return reference;
    }

    public static <T> T checkNotNullFromComponent(T reference) {
        if (reference == null) {
            throw new NullPointerException("Cannot return null from a non-@Nullable component method");
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object errorMessageArg) {
        if (reference == null) {
            if (!errorMessageTemplate.contains("%s")) {
                throw new IllegalArgumentException("errorMessageTemplate has no format specifiers");
            }
            if (errorMessageTemplate.indexOf("%s") != errorMessageTemplate.lastIndexOf("%s")) {
                throw new IllegalArgumentException("errorMessageTemplate has more than one format specifier");
            }
            String argString = errorMessageArg instanceof Class ? ((Class)errorMessageArg).getCanonicalName() : String.valueOf(errorMessageArg);
            throw new NullPointerException(errorMessageTemplate.replace("%s", argString));
        }
        return reference;
    }

    public static <T> void checkBuilderRequirement(T requirement, Class<T> clazz) {
        if (requirement == null) {
            throw new IllegalStateException(clazz.getCanonicalName() + " must be set");
        }
    }

    private Preconditions() {
    }
}

