/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequestManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class WriteRequest<U, V>
extends AbstractRequest<V> {
    private static final Logger LOG = Logger.getLogger(WriteRequest.class);
    private final Functions.Function0<? extends U> nonCancellable;
    private final Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable;
    private final CompletableFuture<Void> allPreviousRequests;

    public WriteRequest(AbstractRequestManager requestManager, Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable, CompletableFuture<Void> allPreviousRequests) {
        super(requestManager);
        this.nonCancellable = nonCancellable;
        this.cancellable = cancellable;
        this.allPreviousRequests = allPreviousRequests;
    }

    @Override
    public void run() {
        block4: {
            try {
                this.allPreviousRequests.join();
            }
            catch (Throwable t) {
                if (this.requestManager.isCancelException(t)) break block4;
                LOG.error((Object)"Error during request: ", t);
            }
        }
        try {
            Object intermediateResult = this.nonCancellable.apply();
            this.cancelIndicator.checkCanceled();
            Object writeResult = this.cancellable.apply((Object)this.cancelIndicator, intermediateResult);
            this.complete(writeResult);
        }
        catch (Throwable t) {
            this.logAndCompleteExceptionally(t);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

