/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.events;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;

@NonNullByDefault
public abstract class AbstractEvent
implements Event {
    public static final String ACTOR_SEPARATOR = "$";
    public static final String DELEGATION_SEPARATOR = "=>";
    public static final String DELEGATION_ESCAPE = "__";
    private final String topic;
    private final String payload;
    private final @Nullable String source;

    protected AbstractEvent(String topic, String payload, @Nullable String source) {
        this.topic = topic;
        this.payload = payload;
        this.source = source;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public @Nullable String getSource() {
        return this.source;
    }

    public int hashCode() {
        int n;
        int prime = 31;
        int result = 1;
        result = 31 * result + this.payload.hashCode();
        String string = this.source;
        if (string instanceof String) {
            String local = string;
            n = local.hashCode();
        } else {
            n = 0;
        }
        result = 31 * result + n;
        result = 31 * result + this.topic.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEvent other = (AbstractEvent)obj;
        if (!this.payload.equals(other.payload)) {
            return false;
        }
        String localSource = this.source;
        if (localSource == null ? other.source != null : !localSource.equals(other.source)) {
            return false;
        }
        return this.topic.equals(other.topic);
    }

    public static String buildSource(String bundle, @Nullable String actor) {
        if (bundle.contains(ACTOR_SEPARATOR)) {
            throw new IllegalArgumentException("Bundle must not contain the actor separator '$'");
        }
        if (bundle.contains(DELEGATION_SEPARATOR)) {
            throw new IllegalArgumentException("Bundle must not contain the delegation separator '=>'");
        }
        if (actor == null || actor.isEmpty()) {
            return bundle;
        }
        actor = actor.replace(DELEGATION_ESCAPE, "____");
        actor = actor.replace(DELEGATION_SEPARATOR, DELEGATION_ESCAPE);
        return bundle + ACTOR_SEPARATOR + actor;
    }

    public static String buildDelegatedSource(@Nullable String originalSource, String bundle) {
        if (originalSource == null || originalSource.isEmpty()) {
            return bundle;
        }
        return originalSource + DELEGATION_SEPARATOR + bundle;
    }

    public static String buildDelegatedSource(@Nullable String originalSource, String bundle, @Nullable String actor) {
        return AbstractEvent.buildDelegatedSource(originalSource, AbstractEvent.buildSource(bundle, actor));
    }
}

