// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"

namespace Rivet {


  /// @brief e+e- > pi+ pi-
  class CMD3_2023_I2634277 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CMD3_2023_I2634277);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_c, "TMP/pion");
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if(fs.particles().size()!=2) vetoEvent;
      for (const Particle& p : fs.particles()) {
	if(abs(p.pid())!=PID::PIPLUS) vetoEvent;
      }
      _c->fill();
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      const double gev2nb =0.389e6;
      const double beta = sqrt(1.-4.*sqr(0.13957039/sqrtS()));
      const double alpha = 1./137.035999084;
      double sigma0 = gev2nb*M_PI*sqr(alpha)*beta*sqr(beta)/3/sqr(sqrtS());
      double fact = crossSection()/ sumOfWeights() /nanobarn /sigma0;
      double sigma = _c->val()*fact;
      double error = _c->err()*fact;
      for(unsigned int ix=1;ix<4;++ix) {
	Scatter2D temphisto(refData(1, ix, 1));
	Scatter2DPtr mult;
	book(mult, 1, ix, 1);
	for (size_t b = 0; b < temphisto.numPoints(); b++) {
	  const double x  = temphisto.point(b).x();
	  pair<double,double> ex = temphisto.point(b).xErrs();
	  pair<double,double> ex2 = ex;
	  if(ex2.first ==0.) ex2. first=0.0001;
	  if(ex2.second==0.) ex2.second=0.0001;
	  if (inRange(sqrtS()/MeV, x-ex2.first, x+ex2.second)) {
	    mult->addPoint(x, sigma, ex, make_pair(error,error));
	  }
	  else {
	    mult->addPoint(x, 0., ex, make_pair(0.,.0));
	  }
	}
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    CounterPtr _c;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(CMD3_2023_I2634277);

}
