/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbConversionPoints;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IdentityDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.data.types.domain.ZonedDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import org.jetbrains.annotations.NotNull;

public final class H2Domains
extends BaseDomainRegistry {
    private static final int TS_FRACTION = 9;
    private static final VersionRange H2_V2 = VersionRange.after((Version)Version.of((int[])new int[]{2}));
    private static final VersionRange H2_V22 = VersionRange.after((Version)Version.of((int[])new int[]{2, 2}));
    private static final VersionRange H2_BEFORE_V22 = VersionRange.before((Version)Version.of((int[])new int[]{2, 2}));

    public H2Domains() {
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true).withAliases(new String[]{"dec", "number", "numeric"}));
        this.add(new Number2Domain("decfloat", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true).withVersionRange(H2_V2));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("mediumblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("longblob", ConversionPoint.BINARY, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("oid", ConversionPoint.BINARY_ID, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withAliases(new String[]{"binary varying"}));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING).withAliases(new String[]{"binary large object"}));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN).withAliases(new String[]{"bool", "bit"}));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases(new String[]{"integer", "int4", "mediumint", "signed"}));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withAliases(new String[]{"int2"}));
        this.add(new IntegerDomain("year", ConversionPoint.YEAR, -32768.0, 32767.0).withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18).withAliases(new String[]{"int8"}));
        this.add((Domain)new MyIdentityDomain((Domain)new IntegerDomain("identity", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18)));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE).withAliases(new String[]{"double precision", "float8"}));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38).withAliases(new String[]{"float4"}));
        this.add(new SimpleDomain("date", ConversionPoint.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 0, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new ZonedDomain(new FractionDomain("time with time zone", DbConversionPoints.TIME_WITH_TIMEZONE, 9, 0, true), "time").withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 9, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new ZonedDomain(new FractionDomain("timestamp with time zone", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 9, 6, true), "timestamp").withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, 9, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime2", ConversionPoint.TIMESTAMP, 9, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("smalldatetime", ConversionPoint.TIMESTAMP, 9, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true, true).withAliases(new String[]{"tinytext", "mediumtext", "longvarchar"}).withVersionRange(H2_BEFORE_V22));
        this.add(new TextDomain("text", ConversionPoint.TEXT, 1000000000L, -1L, true, true).withAliases(new String[]{"tinytext", "mediumtext", "longvarchar"}).withVersionRange(H2_V22));
        this.add(new TextDomain("ntext", ConversionPoint.NTEXT, Integer.MAX_VALUE, -1L, true, true).withVersionRange(H2_BEFORE_V22));
        this.add(new TextDomain("ntext", ConversionPoint.NTEXT, 1000000000L, -1L, true, true).withVersionRange(H2_V22));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, Integer.MAX_VALUE, -1L, true, true).withAliases(new String[]{"character varying", "varchar2"}).withVersionRange(H2_BEFORE_V22));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 1000000000L, -1L, true, true).withAliases(new String[]{"character varying", "varchar2"}).withVersionRange(H2_V22));
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, Integer.MAX_VALUE, -1L, true, true).withAliases(new String[]{"nvarchar2"}).withVersionRange(H2_BEFORE_V22));
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 1000000000L, -1L, true, true).withAliases(new String[]{"nvarchar2"}).withVersionRange(H2_V22));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true, true).withAliases(new String[]{"character large object"}).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("nclob", ConversionPoint.NTEXT, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("varchar_ignorecase", ConversionPoint.VARCHAR, Integer.MAX_VALUE, -1L, true, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, Integer.MAX_VALUE, 1L, true, true).withAliases(new String[]{"char"}));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, Integer.MAX_VALUE, 1L, true, true));
        this.add(new BinaryDomain("image", ConversionPoint.GRAPHIC, Integer.MAX_VALUE, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("uuid", ConversionPoint.UUID_TEXT).withAliases(new String[]{"uniqueidentifier"}).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new UnknownDomain("array").withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new UnknownDomain("other"));
        this.add(new SimpleDomain("geometry", ConversionPoint.GEOMETRY).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new UnknownDomain("long").withOperationSupport(OperationSupport.SUPPORTS_NUMERIC_EQUALS));
        this.add((Domain)new UnknownDomain("longvarbinary"));
        this.add((Domain)new UnknownDomain("raw"));
        this.add((Domain)new UnknownDomain("long raw"));
        this.add((Domain)new UnknownDomain("bytea"));
        this.add((Domain)new UnknownDomain("object"));
        this.add((Domain)new UnknownDomain("java_object"));
    }

    private static class MyIdentityDomain
    extends IdentityDomain {
        MyIdentityDomain(@NotNull Domain domain) {
            if (domain == null) {
                MyIdentityDomain.$$$reportNull$$$0(0);
            }
            super(domain);
        }

        @NotNull
        public String name() {
            String string = this.unwrap().name();
            if (string == null) {
                MyIdentityDomain.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
            if (descriptor2 == null) {
                MyIdentityDomain.$$$reportNull$$$0(2);
            }
            return this.unwrap().isSuitable(descriptor2);
        }

        @NotNull
        protected IdentityDomain createDomain(@NotNull Domain domain) {
            if (domain == null) {
                MyIdentityDomain.$$$reportNull$$$0(3);
            }
            return new MyIdentityDomain(domain);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/h2/H2Domains$MyIdentityDomain";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/h2/H2Domains$MyIdentityDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuitable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDomain";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

