/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.model;

import com.intellij.database.dialects.h2.model.H2DomainCheck;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2Role;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.GeneratedModelUtil;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class H2GeneratedModelUtil
extends GeneratedModelUtil {
    public static SequenceIdentity getSequenceIdentity(@NotNull H2TableColumn column2) {
        BasicReferenceInfo<? extends H2Sequence> info2;
        if (column2 == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(0);
        }
        if ((info2 = column2.getSequenceRefInfo()) == null) {
            return null;
        }
        H2Sequence seq = (H2Sequence)info2.getTargetOrInlineData();
        return seq == null ? SequenceIdentity.UNKNOWN : seq.getSequenceIdentity();
    }

    public static void setSequenceIdentity(H2TableColumn column2, SequenceIdentity identity) {
        BasicMetaObject meta;
        if (identity == null) {
            column2.setSequenceRef(null);
            return;
        }
        if (identity.equals((Object)H2GeneratedModelUtil.getSequenceIdentity(column2))) {
            return;
        }
        BasicReferenceInfo<? extends H2Sequence> info2 = column2.getSequenceRefInfo();
        H2Sequence prev2 = info2 == null ? null : (H2Sequence)info2.getTargetOrInlineData();
        BasicMetaReferenceDesc desc = BasicMetaUtils.getReferenceDesc((BasicMetaField)column2.getMetaObject().getReference(H2TableColumn.SEQUENCE_REF));
        BasicMetaObject basicMetaObject = meta = desc == null ? null : (BasicMetaObject)ArrayUtil.getFirstElement((Object[])desc.targets);
        if (meta == null) {
            return;
        }
        H2Sequence seq = (H2Sequence)meta.newDataObject();
        if (prev2 != null) {
            BasicMetaUtils.copyProperties((BasicElement)prev2, (BasicModElement)seq, (boolean)false, (boolean)false);
        }
        seq.setSequenceIdentity(identity);
        BasicDataObject.freeze((BasicElement)seq);
        column2.setSequenceRef((BasicReference)BasicInlineObjectReference.create((BasicElement)seq));
    }

    public static int getDisplayOrder(@NotNull H2Sequence e1, @NotNull H2Sequence e2) {
        if (e1 == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(1);
        }
        if (e2 == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(2);
        }
        boolean s1 = e1.isNameSurrogate();
        boolean s2 = e2.isNameSurrogate();
        if (!s1 && !s2) {
            return H2GeneratedModelUtil.getDisplayOrder((BasicElement)e1, (BasicElement)e2);
        }
        if (s1 != s2) {
            return Boolean.compare(s1, s2);
        }
        SequenceIdentity si1 = e1.getSequenceIdentity();
        SequenceIdentity si2 = e2.getSequenceIdentity();
        int res2 = Comparing.compare((Comparable)si1.min, (Comparable)si2.min);
        if (res2 != 0) {
            return res2;
        }
        res2 = Comparing.compare((Comparable)si1.max, (Comparable)si2.max);
        if (res2 != 0) {
            return res2;
        }
        res2 = Comparing.compare((Comparable)si1.increment, (Comparable)si2.increment);
        if (res2 != 0) {
            return res2;
        }
        res2 = Boolean.compare(e1.isCycled(), e2.isCycled());
        if (res2 != 0) {
            return res2;
        }
        res2 = Long.compare(e1.getCacheSize(), e2.getCacheSize());
        if (res2 != 0) {
            return res2;
        }
        res2 = Comparing.compare((Comparable)((Object)e1.getComment()), (Comparable)((Object)e2.getComment()));
        return res2;
    }

    public static boolean getAutoCreated(@NotNull H2Sequence element) {
        if (element == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(3);
        }
        return element.isNameSurrogate();
    }

    public static boolean getAutoCreated(@NotNull H2Index element) {
        if (element == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return element.isNameSurrogate();
    }

    public static boolean getAutoCreated(@NotNull H2Role element) {
        if (element == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(5);
        }
        return element.getName().equals("PUBLIC");
    }

    public static List<String> getRefColNames(H2ForeignKey fk) {
        return H2GeneratedModelUtil.getRefColNamesByKey((BasicForeignKey)fk);
    }

    public static void setRefColNames(H2ForeignKey fk, List<String> names) {
        H2GeneratedModelUtil.setRefColNamesByKey((BasicModForeignKey)fk, names);
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull H2DomainCheck element) {
        if (element == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = H2GeneratedModelUtil.getPredecessors((BasicElement)element);
        if (jBIterable == null) {
            H2GeneratedModelUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public static boolean isComputed(H2TableColumn column2) {
        return column2.getColumnKind() != ColumnKind.NORMAL;
    }

    public static void setComputed(H2TableColumn column2, boolean computed) {
        if (computed == H2GeneratedModelUtil.isComputed(column2)) {
            return;
        }
        column2.setColumnKind(computed ? ColumnKind.GENERATED_VIRTUAL : ColumnKind.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/model/H2GeneratedModelUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/model/H2GeneratedModelUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceIdentity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

