/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.bigquery.BigQueryDialect;
import com.intellij.sql.dialects.bigquery.BigQueryTokens;
import com.intellij.sql.dialects.bigquery._BigQueryLexer;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class BigQueryLexer
extends SqlLexer {
    public BigQueryLexer() {
        super((SqlLanguageDialectBase)BigQueryDialect.INSTANCE, (FlexLexer)new _BigQueryLexer());
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            BigQueryLexer.$$$reportNull$$$0(0);
        }
        if (this.lookAheadCustomQuotes(baseLexer)) {
            return;
        }
        if (this.lookAheadQuotedIdentifierPath(baseLexer, BigQueryTokens.BQ_DELIMITED_TOKEN_START, BigQueryTokens.BQ_DELIMITED_TOKEN_END)) {
            return;
        }
        super.lookAhead(baseLexer);
    }

    private boolean lookAheadCustomQuotes(Lexer lexer) {
        int start2;
        if (lexer.getTokenType() != SqlTokens.SQL_STRING_TOKEN) {
            return false;
        }
        String originalText = lexer.getTokenText();
        for (start2 = 0; start2 < originalText.length() && (originalText.charAt(start2) == 'r' || originalText.charAt(start2) == 'R' || originalText.charAt(start2) == 'b' || originalText.charAt(start2) == 'B'); ++start2) {
        }
        String text = originalText.substring(start2);
        if (!"''".equals(text) && !"\"\"".equals(text)) {
            return false;
        }
        char quote = text.charAt(0);
        CharSequence sequence = lexer.getBufferSequence();
        if (sequence.length() <= lexer.getTokenStart() + originalText.length() || sequence.charAt(lexer.getTokenStart() + originalText.length()) != quote) {
            return false;
        }
        lexer.advance();
        String ident = StringUtil.repeat((String)new String(new char[]{quote}), (int)3);
        int stringStart = lexer.getTokenStart() + 1;
        return this.processCustomQuotation(lexer, ident, stringStart);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/bigquery/BigQueryLexer", "lookAhead"));
    }
}

