/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.ShNotification;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShellcheckSetupNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(1);
        }
        if (!(file.getFileType() instanceof ShFileType) || ShShellcheckUtil.isValidPath(ShSettings.getShellcheckPath(project))) {
            return null;
        }
        return fileEditor -> {
            EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            panel.setText(ShBundle.message("sh.shellcheck.install.question", new Object[0]));
            Runnable onSuccess = () -> {
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                }
                ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.success.install", new Object[0]), NotificationType.INFORMATION).notify(project);
            };
            Runnable onFailure = () -> ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.cannot.download", new Object[0]), NotificationType.ERROR).notify(project);
            panel.createActionLabel(ShBundle.message("sh.install", new Object[0]), () -> ShShellcheckUtil.download(project, onSuccess, onFailure));
            panel.createActionLabel(ShBundle.message("sh.no.thanks", new Object[0]), () -> {
                ShSettings.setShellcheckPath(project, ShSettings.I_DO_MIND_SUPPLIER.get());
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            return panel;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/sh/shellcheck/ShellcheckSetupNotificationProvider";
        objectArray[2] = "collectNotificationData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

