/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationUtils;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;

public abstract class FileSystemConfigBuilder {
    private static final String PREFIX = "vfs.";
    private static final String ROOTURI = "rootURI";
    private final String prefix;

    protected FileSystemConfigBuilder() {
        this.prefix = PREFIX;
    }

    protected FileSystemConfigBuilder(String component) {
        this.prefix = PREFIX + component;
    }

    public void setRootURI(FileSystemOptions fileSystemOptions, String rootURI) {
        this.setParam(fileSystemOptions, ROOTURI, rootURI);
    }

    public String getRootURI(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, ROOTURI);
    }

    protected void setParam(FileSystemOptions fileSystemOptions, String name, boolean value) {
        this.setParam(fileSystemOptions, name, (Object)value);
    }

    protected void setParam(FileSystemOptions fileSystemOptions, String name, Object value) {
        Objects.requireNonNull(fileSystemOptions, "fileSystemOptions").setOption(this.getConfigClass(), name, value);
    }

    protected <T> T getParam(FileSystemOptions fileSystemOptions, String name) {
        return fileSystemOptions == null ? null : (T)fileSystemOptions.getOption(this.getConfigClass(), name);
    }

    private <T> T getParam(FileSystemOptions fileSystemOptions, String name, T defaultValue, Function<String, T> function) {
        T value = this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            if (function != null) {
                value = function.apply(str);
            }
        }
        return value;
    }

    protected boolean hasParam(FileSystemOptions fileSystemOptions, String name) {
        return fileSystemOptions != null && fileSystemOptions.hasOption(this.getConfigClass(), name);
    }

    protected boolean hasObject(FileSystemOptions fileSystemOptions, String name) {
        return this.hasParam(fileSystemOptions, name) || System.getProperties().containsKey(this.toPropertyKey(name));
    }

    protected Boolean toBooleanObject(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String name) {
        return this.getBoolean(fileSystemOptions, name, null);
    }

    protected boolean getBoolean(FileSystemOptions fileSystemOptions, String name, boolean defaultValue) {
        return this.getBoolean(fileSystemOptions, name, (Boolean)defaultValue);
    }

    protected Boolean getBoolean(FileSystemOptions fileSystemOptions, String name, Boolean defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Boolean::valueOf);
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String name) {
        return this.getByte(fileSystemOptions, name, null);
    }

    protected byte getByte(FileSystemOptions fileSystemOptions, String name, byte defaultValue) {
        return this.getByte(fileSystemOptions, name, (Byte)defaultValue);
    }

    protected Byte getByte(FileSystemOptions fileSystemOptions, String name, Byte defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Byte::valueOf);
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String name) {
        return this.getCharacter(fileSystemOptions, name, null);
    }

    protected char getCharacter(FileSystemOptions fileSystemOptions, String name, char defaultValue) {
        return this.getCharacter(fileSystemOptions, name, Character.valueOf(defaultValue)).charValue();
    }

    protected Character getCharacter(FileSystemOptions fileSystemOptions, String name, Character defaultValue) {
        Character value = (Character)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (StringUtils.isEmpty((CharSequence)str)) {
                return defaultValue;
            }
            value = Character.valueOf(str.charAt(0));
        }
        return value;
    }

    protected Double getDouble(FileSystemOptions fileSystemOptions, String name) {
        return this.getDouble(fileSystemOptions, name, null);
    }

    protected double getDouble(FileSystemOptions fileSystemOptions, String name, double defaultValue) {
        return this.getDouble(fileSystemOptions, name, (Double)defaultValue);
    }

    protected Double getDouble(FileSystemOptions fileSystemOptions, String name, Double defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Double::valueOf);
    }

    protected <E extends Enum<E>> E getEnum(Class<E> enumClass, FileSystemOptions fileSystemOptions, String name) {
        return this.getEnum(enumClass, fileSystemOptions, name, null);
    }

    protected <E extends Enum<E>> E getEnum(Class<E> enumClass, FileSystemOptions fileSystemOptions, String name, E defaultValue) {
        Enum value = (Enum)this.getParam(fileSystemOptions, name);
        if (value == null) {
            String str = this.getProperty(name);
            if (str == null) {
                return defaultValue;
            }
            value = Enum.valueOf(enumClass, str);
        }
        return (E)value;
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String name) {
        return this.getFloat(fileSystemOptions, name, null);
    }

    protected float getFloat(FileSystemOptions fileSystemOptions, String name, float defaultValue) {
        return this.getFloat(fileSystemOptions, name, new Float(defaultValue)).floatValue();
    }

    protected Float getFloat(FileSystemOptions fileSystemOptions, String name, Float defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Float::valueOf);
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String name) {
        return this.getInteger(fileSystemOptions, name, null);
    }

    protected int getInteger(FileSystemOptions fileSystemOptions, String name, int defaultValue) {
        return this.getInteger(fileSystemOptions, name, (Integer)defaultValue);
    }

    protected Integer getInteger(FileSystemOptions fileSystemOptions, String name, Integer defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Integer::valueOf);
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String name) {
        return this.getLong(fileSystemOptions, name, null);
    }

    protected long getLong(FileSystemOptions fileSystemOptions, String name, long defaultValue) {
        return this.getLong(fileSystemOptions, name, (Long)defaultValue);
    }

    protected Long getLong(FileSystemOptions fileSystemOptions, String name, Long defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Long::valueOf);
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String name) {
        return this.getShort(fileSystemOptions, name, null);
    }

    protected short getShort(FileSystemOptions fileSystemOptions, String name, short defaultValue) {
        return this.getShort(fileSystemOptions, name, (Short)defaultValue);
    }

    protected Short getShort(FileSystemOptions fileSystemOptions, String name, Short defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Short::valueOf);
    }

    protected String getString(FileSystemOptions fileSystemOptions, String name) {
        return this.getString(fileSystemOptions, name, null);
    }

    protected String getString(FileSystemOptions fileSystemOptions, String name, String defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, String::valueOf);
    }

    protected abstract Class<? extends FileSystem> getConfigClass();

    private String toPropertyKey(String name) {
        return this.prefix + name;
    }

    private String getProperty(String name) {
        return System.getProperty(this.toPropertyKey(name));
    }

    protected Duration getDuration(FileSystemOptions fileSystemOptions, String name) {
        return this.getDuration(fileSystemOptions, name, null);
    }

    protected Duration getDuration(FileSystemOptions fileSystemOptions, String name, Duration defaultValue) {
        return this.getParam(fileSystemOptions, name, defaultValue, Duration::parse);
    }

    protected Integer getDurationInteger(FileSystemOptions fileSystemOptions, String name) {
        return this.getDurationInteger(fileSystemOptions, name, null);
    }

    protected Integer getDurationInteger(FileSystemOptions fileSystemOptions, String name, Duration defaultValue) {
        return DurationUtils.toMillisInt((Duration)this.getParam(fileSystemOptions, name, defaultValue, Duration::parse));
    }
}

