/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DumbIntrospectionContext;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0006\u001a*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0006H\u0007\u001a\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e\u001a \u0010\u001f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\""}, d2={"INTRO_EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "getINTRO_EP", "()Lcom/intellij/database/DbmsExtension;", "supportedByNativeIntrospector", "", "db", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "dbms", "Lcom/intellij/database/Dbms;", "version", "Lcom/intellij/database/util/Version;", "hasNativeIntrospector", "hasIncrementalIntrospector", "hasFragmentIntrospector", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "generic", "getCurrentSrcIntrospectionVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.core.impl"})
@JvmName(name="DBIntrospectorFactory")
public final class DBIntrospectorFactory {
    @NotNull
    private static final DbmsExtension<DBIntrospector.Factory> INTRO_EP = new DbmsExtension("com.intellij.database.introspector");

    @NotNull
    public static final DbmsExtension<DBIntrospector.Factory> getINTRO_EP() {
        return INTRO_EP;
    }

    public static final boolean supportedByNativeIntrospector(@NotNull DatabaseConnectionCore db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Dbms dbms = db.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Version version = db.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getVersion(...)");
        return DBIntrospectorFactory.supportedByNativeIntrospector(dbms, version);
    }

    public static final boolean supportedByNativeIntrospector(@NotNull Dbms dbms, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        DBIntrospector.Factory factory = INTRO_EP.forDbms(dbms);
        return factory.isNative() && factory.isSupported(version);
    }

    public static final boolean hasNativeIntrospector(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return INTRO_EP.forDbms(dbms).isNative();
    }

    public static final boolean hasIncrementalIntrospector(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return INTRO_EP.forDbms(dbms).isIncremental();
    }

    public static final boolean hasFragmentIntrospector(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return INTRO_EP.forDbms(dbms).supportsFragmentIntrospection();
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Dbms dbms = dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        Version version = dataSource.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getVersion(...)");
        Version version2 = version;
        boolean forceGeneric = dataSource.useJdbcIntrospector();
        if (!forceGeneric) {
            forceGeneric = !DBIntrospectorFactory.supportedByNativeIntrospector(dbms2, version2);
        }
        return DBIntrospectorFactory.createIntrospector(context, modelFactory, dbms2, forceGeneric);
    }

    @Deprecated(message="Use the method that accepts a context instead of a project")
    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DumbIntrospectionContext context = new DumbIntrospectionContext(project);
        return DBIntrospectorFactory.createIntrospector(context, modelFactory, dataSource);
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @Nullable ModelFactory modelFactory, @NotNull Dbms dbms, boolean generic) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        DBIntrospector.Factory factory = INTRO_EP.forDbms(generic ? Dbms.UNKNOWN : dbms);
        ModelFactory modelFactory2 = modelFactory;
        if (modelFactory2 == null) {
            modelFactory2 = new ModelFactory(BlackHoleTextStorage.INSTANCE);
        }
        return factory.createIntrospector(context, dbms, modelFactory2);
    }

    @Deprecated(message="Use the method that accepts a context instead of a project")
    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull Project project, @Nullable ModelFactory modelFactory, @NotNull Dbms dbms, boolean generic) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        DumbIntrospectionContext context = new DumbIntrospectionContext(project);
        return DBIntrospectorFactory.createIntrospector(context, modelFactory, dbms, generic);
    }

    public static final int getCurrentSrcIntrospectionVersion(@NotNull Dbms dbms, @NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return INTRO_EP.forDbms(dbms).getVersion(kind);
    }

    public static final boolean isOutdatedCheckSupported(@NotNull Dbms dbms, boolean generic, @Nullable BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return INTRO_EP.forDbms(generic ? Dbms.UNKNOWN : dbms).isOutdatedCheckSupported(e);
    }
}

