/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.locate;

import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class SimplePointInAreaLocator
implements PointOnGeometryLocator {
    private Geometry geom;

    public static int locate(Coordinate p2, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (!geom.getEnvelopeInternal().intersects(p2)) {
            return 2;
        }
        return SimplePointInAreaLocator.locateInGeometry(p2, geom);
    }

    public static boolean isContained(Coordinate p2, Geometry geom) {
        return 2 != SimplePointInAreaLocator.locate(p2, geom);
    }

    private static int locateInGeometry(Coordinate p2, Geometry geom) {
        if (geom instanceof Polygon) {
            return SimplePointInAreaLocator.locatePointInPolygon(p2, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                int loc;
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom || (loc = SimplePointInAreaLocator.locateInGeometry(p2, g2)) == 2) continue;
                return loc;
            }
        }
        return 2;
    }

    public static int locatePointInPolygon(Coordinate p2, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = poly.getExteriorRing();
        int shellLoc = SimplePointInAreaLocator.locatePointInRing(p2, shell);
        if (shellLoc != 0) {
            return shellLoc;
        }
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = poly.getInteriorRingN(i2);
            int holeLoc = SimplePointInAreaLocator.locatePointInRing(p2, hole);
            if (holeLoc == 1) {
                return 1;
            }
            if (holeLoc != 0) continue;
            return 2;
        }
        return 0;
    }

    public static boolean containsPointInPolygon(Coordinate p2, Polygon poly) {
        return 2 != SimplePointInAreaLocator.locatePointInPolygon(p2, poly);
    }

    private static int locatePointInRing(Coordinate p2, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p2)) {
            return 2;
        }
        return PointLocation.locateInRing(p2, ring.getCoordinates());
    }

    public SimplePointInAreaLocator(Geometry geom) {
        this.geom = geom;
    }

    @Override
    public int locate(Coordinate p2) {
        return SimplePointInAreaLocator.locate(p2, this.geom);
    }
}

