/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/grazie/jlanguage/Lang;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/grazie/jlanguage/Lang;)V", "selectedFile", "Ljava/nio/file/Path;", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "ChooseLanguageBundleAction", "LanguageBundleFileChooserDescriptor", "Companion", "intellij.grazie.core"})
public final class OfflineLanguageBundleSelectionDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Lang language;
    @Nullable
    private Path selectedFile;

    private OfflineLanguageBundleSelectionDialog(Project project, Lang language) {
        super(project, true);
        this.project = project;
        this.language = language;
        String[] stringArray = new String[]{this.language.getNativeName()};
        this.setTitle(SwingKTKt.msg("grazie.offline.language.bundle.dialog.title", stringArray));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> OfflineLanguageBundleSelectionDialog.createCenterPanel$lambda$1(this, arg_0));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        actionArray[1] = new ChooseLanguageBundleAction();
        return actionArray;
    }

    private static final Unit createCenterPanel$lambda$1$lambda$0(OfflineLanguageBundleSelectionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String[] stringArray = new String[]{this$0.language.getNativeName(), this$0.language.getRemote().getUrl()};
        Row.text$default((Row)$this$row, (String)SwingKTKt.msg("grazie.offline.language.bundle.dialog.text", stringArray), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$1(OfflineLanguageBundleSelectionDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> OfflineLanguageBundleSelectionDialog.createCenterPanel$lambda$1$lambda$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    public /* synthetic */ OfflineLanguageBundleSelectionDialog(Project project, Lang language, DefaultConstructorMarker $constructor_marker) {
        this(project, language);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog$ChooseLanguageBundleAction;", "Ljavax/swing/AbstractAction;", "<init>", "(Lcom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "chooseFile", "Ljava/nio/file/Path;", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nOfflineLanguageBundleSelectionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineLanguageBundleSelectionDialog.kt\ncom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog$ChooseLanguageBundleAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
    private final class ChooseLanguageBundleAction
    extends AbstractAction {
        public ChooseLanguageBundleAction() {
            super(SwingKTKt.msg("grazie.offline.language.bundle.dialog.select.action.text", new String[0]));
            this.putValue("DefaultAction", true);
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent event) {
            OfflineLanguageBundleSelectionDialog.this.selectedFile = this.chooseFile();
            if (OfflineLanguageBundleSelectionDialog.this.selectedFile != null) {
                OfflineLanguageBundleSelectionDialog.this.close(0);
            }
        }

        private final Path chooseFile() {
            Path path;
            Path file;
            LanguageBundleFileChooserDescriptor descriptor = new LanguageBundleFileChooserDescriptor(OfflineLanguageBundleSelectionDialog.this.language);
            FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)descriptor, OfflineLanguageBundleSelectionDialog.this.project, null);
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
            FileChooserDialog chooser = fileChooserDialog;
            VirtualFile[] virtualFileArray = chooser.choose(OfflineLanguageBundleSelectionDialog.this.project, new VirtualFile[0]);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
            Path path2 = file = virtualFile != null ? virtualFile.toNioPath() : null;
            if (path2 != null) {
                Path path3 = path2;
                OfflineLanguageBundleSelectionDialog offlineLanguageBundleSelectionDialog = OfflineLanguageBundleSelectionDialog.this;
                Path it = path3;
                boolean bl = false;
                path = GrazieRemote.INSTANCE.isValidBundleForLanguage(offlineLanguageBundleSelectionDialog.language, it) ? path3 : null;
            } else {
                path = null;
            }
            return path;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog$Companion;", "", "<init>", "()V", "show", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/grazie/jlanguage/Lang;", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Path show(@Nullable Project project, @NotNull Lang language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            OfflineLanguageBundleSelectionDialog dialog = new OfflineLanguageBundleSelectionDialog(project, language, null);
            boolean result = dialog.showAndGet();
            if (!result) {
                return null;
            }
            return dialog.selectedFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/remote/OfflineLanguageBundleSelectionDialog$LanguageBundleFileChooserDescriptor;", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "language", "Lcom/intellij/grazie/jlanguage/Lang;", "<init>", "(Lcom/intellij/grazie/jlanguage/Lang;)V", "isFileSelectable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "validateSelectedFiles", "", "files", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.grazie.core"})
    private static final class LanguageBundleFileChooserDescriptor
    extends FileChooserDescriptor {
        @NotNull
        private final Lang language;

        public LanguageBundleFileChooserDescriptor(@NotNull Lang language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            super(true, false, true, true, false, false);
            this.language = language;
            String[] stringArray = new String[]{this.language.getNativeName()};
            this.setTitle(SwingKTKt.msg("grazie.offline.language.bundle.dialog.descriptor.title", stringArray));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isFileSelectable(@Nullable VirtualFile file) {
            if (!super.isFileSelectable(file)) return false;
            VirtualFile virtualFile = file;
            if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getExtension() : null), (Object)"jar")) return false;
            return true;
        }

        public void validateSelectedFiles(@NotNull VirtualFile[] files) {
            Intrinsics.checkNotNullParameter((Object)files, (String)"files");
            super.validateSelectedFiles(files);
            for (VirtualFile file : files) {
                Path path;
                Intrinsics.checkNotNullExpressionValue((Object)file.toNioPath(), (String)"toNioPath(...)");
                if (GrazieRemote.INSTANCE.isValidBundleForLanguage(this.language, path)) continue;
                String[] stringArray = new String[2];
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                stringArray[1] = this.language.getNativeName();
                throw new Exception(SwingKTKt.msg("grazie.offline.language.bundle.dialog.descriptor.error", stringArray));
            }
        }
    }
}

