/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.preprocessor;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureDeclaration;
import com.jetbrains.mlapi.feature.FeatureSet;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.preprocessor.FeatureTransformer;
import com.jetbrains.mlapi.feature.preprocessor.TfIdfVectorizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002 !BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer;", "Lcom/jetbrains/mlapi/feature/preprocessor/FeatureTransformer;", "featureName", "", "vocabToIdf", "", "", "analyzer", "Lcom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer$Analizer;", "ngramRange", "Lkotlin/ranges/IntRange;", "lowercase", "", "normalize", "(Ljava/lang/String;Ljava/util/Map;Lcom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer$Analizer;Lkotlin/ranges/IntRange;ZZ)V", "output", "", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "getOutput", "()Ljava/util/Collection;", "charNgrams", "", "text", "charWbNgrams", "normalizeL2", "tfIdf", "transformFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "feature", "requiredOutput", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "wordNgrams", "Analizer", "Companion", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nTfIdfVectorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfIdfVectorizer.kt\ncom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n766#2:123\n857#2,2:124\n1536#2:126\n1238#2,4:129\n1549#2:133\n1620#2,3:134\n1360#2:137\n1446#2,2:138\n766#2:140\n857#2,2:141\n1360#2:143\n1446#2,5:144\n1448#2,3:149\n766#2:152\n857#2,2:153\n1360#2:155\n1446#2,5:156\n1373#2:161\n1461#2,5:162\n1549#2:167\n1620#2,3:168\n1238#2,4:173\n453#3:127\n403#3:128\n453#3:171\n403#3:172\n*S KotlinDebug\n*F\n+ 1 TfIdfVectorizer.kt\ncom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer\n*L\n27#1:119\n27#1:120,3\n37#1:123\n37#1:124,2\n37#1:126\n38#1:129,4\n43#1:133\n43#1:134,3\n54#1:137\n54#1:138,2\n57#1:140\n57#1:141,2\n58#1:143\n58#1:144,5\n54#1:149,3\n68#1:152\n68#1:153,2\n69#1:155\n69#1:156,5\n76#1:161\n76#1:162,5\n82#1:167\n82#1:168,3\n84#1:173,4\n38#1:127\n38#1:128\n84#1:171\n84#1:172\n*E\n"})
public final class TfIdfVectorizer
extends FeatureTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Float> vocabToIdf;
    @NotNull
    private final Analizer analyzer;
    @NotNull
    private final IntRange ngramRange;
    private final boolean lowercase;
    private final boolean normalize;
    @NotNull
    private final Collection<FeatureSignature> output;
    @NotNull
    private static final Regex tokenPattern = new Regex("\\b\\w\\w+\\b");
    @NotNull
    private static final Regex spacePattern = new Regex("\\s\\s+");

    /*
     * WARNING - void declaration
     */
    public TfIdfVectorizer(@NotNull String featureName, @NotNull Map<String, Float> vocabToIdf, @NotNull Analizer analyzer, @NotNull IntRange ngramRange, boolean lowercase, boolean normalize) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(vocabToIdf, (String)"vocabToIdf");
        Intrinsics.checkNotNullParameter((Object)((Object)analyzer), (String)"analyzer");
        Intrinsics.checkNotNullParameter((Object)ngramRange, (String)"ngramRange");
        super(FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, featureName, null, null, 6, null));
        this.vocabToIdf = vocabToIdf;
        this.analyzer = analyzer;
        this.ngramRange = ngramRange;
        this.lowercase = lowercase;
        this.normalize = normalize;
        Iterable iterable = this.vocabToIdf.keySet();
        TfIdfVectorizer tfIdfVectorizer = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FeatureDeclaration.Companion.float$default(FeatureDeclaration.Companion, (String)it, null, null, 6, null));
        }
        tfIdfVectorizer.output = (List)destination$iv$iv;
    }

    public /* synthetic */ TfIdfVectorizer(String string, Map map, Analizer analizer, IntRange intRange, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            analizer = Analizer.CHAR_WB;
        }
        if ((n & 8) != 0) {
            intRange = new IntRange(1, 3);
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        this(string, map, analizer, intRange, bl, bl2);
    }

    @Override
    @NotNull
    public Collection<FeatureSignature> getOutput() {
        return this.output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<Feature> transformFeature(@NotNull Feature feature, @NotNull FeatureSet requiredOutput) {
        void $this$mapTo$iv$iv;
        Object object;
        String it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$groupingBy$iv;
        Map termFrequencies;
        void $this$filterTo$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)requiredOutput, (String)"requiredOutput");
        String text = feature.getAsStringFeature().getStringValue();
        if (this.lowercase) {
            String string2 = text.toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string = text;
        }
        String textToTransform = string;
        List<String> tokens2 = switch (WhenMappings.$EnumSwitchMapping$0[this.analyzer.ordinal()]) {
            case 1 -> this.wordNgrams(textToTransform);
            case 2 -> this.charNgrams(textToTransform);
            case 3 -> this.charWbNgrams(textToTransform);
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$filter$iv = tokens2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.vocabToIdf.containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Map $this$mapValues$iv = termFrequencies = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map<String, Float> destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map<String, Float> map = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map;
            boolean bl2 = false;
            String term = (String)entry2.getKey();
            int tf = ((Number)entry2.getValue()).intValue();
            Float f = Float.valueOf((float)tf * ((Number)MapsKt.getValue(this.vocabToIdf, (Object)term)).floatValue());
            object.put(k, (Float)f);
        }
        Map<String, Float> tfIdf = destination$iv$iv2;
        Map<String, Float> normalizedTfIdf = this.normalize ? this.normalizeL2(tfIdf) : tfIdf;
        Iterable $this$map$iv = this.vocabToIdf.keySet();
        boolean $i$f$map = false;
        Iterable $i$f$mapValuesTo22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void word;
            it$iv$iv = (String)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            float featureValue = ((Number)normalizedTfIdf.getOrDefault(word, Float.valueOf(0.0f))).floatValue();
            object.add(FeatureDeclaration.Companion.float$default(FeatureDeclaration.Companion, (String)word, null, null, 6, null).with(Float.valueOf(featureValue)));
        }
        List resultFeatures = (List)destination$iv$iv3;
        return requiredOutput.selectFeatures(resultFeatures);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> charWbNgrams(String text) {
        void $this$flatMapTo$iv$iv;
        String[] stringArray = new String[]{" "};
        List tokens2 = StringsKt.split$default((CharSequence)spacePattern.replace((CharSequence)text, " "), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$flatMap$iv = tokens2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String word = (String)element$iv$iv;
            boolean bl = false;
            String token = " " + word + " ";
            Iterable iterable2 = (Iterable)this.ngramRange;
            boolean $i$f$filter = false;
            void var16_16 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv2).intValue();
                boolean bl2 = false;
                if (!(it <= token.length())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap2 = false;
            $this$filterTo$iv$iv = $this$flatMap$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                int nGramSize = ((Number)element$iv$iv2).intValue();
                boolean bl3 = false;
                Iterable list$iv$iv = StringsKt.windowed$default((CharSequence)token, (int)nGramSize, (int)1, (boolean)false, (int)4, null);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List ngrams = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)ngrams);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> charNgrams(String text) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)this.ngramRange;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it <= text.length())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int ngramSize = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            Iterable list$iv$iv = StringsKt.windowed$default((CharSequence)text, (int)ngramSize, (int)1, (boolean)false, (int)4, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> wordNgrams(String text) {
        void $this$flatMapTo$iv$iv;
        String string = text.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Sequence tokens2 = SequencesKt.map((Sequence)Regex.findAll$default((Regex)tokenPattern, (CharSequence)string, (int)0, (int)2, null), (Function1)wordNgrams.tokens.1.INSTANCE);
        Iterable $this$flatMap$iv = (Iterable)this.ngramRange;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int n = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Sequence list$iv$iv = SequencesKt.windowed$default((Sequence)SequencesKt.filter((Sequence)tokens2, (Function1)((Function1)new Function1<String, Boolean>(n){
                final /* synthetic */ int $n;
                {
                    this.$n = $n;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.length() >= this.$n;
                }
            })), (int)n, (int)1, (boolean)false, (Function1)wordNgrams.1.2.INSTANCE, (int)4, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Float> normalizeL2(Map<String, Float> tfIdf) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map<String, Float> $this$mapTo$iv$iv;
        Iterable $this$map$iv = tfIdf.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            float f = ((Number)item$iv$iv).floatValue();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(Float.valueOf((float)(it * it)));
        }
        float norm = (float)Math.sqrt(CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)));
        if (norm == 0.0f) {
            return tfIdf;
        }
        Map<String, Float> $this$mapValues$iv = tfIdf;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            float value = ((Number)entry2.getValue()).floatValue();
            Float f = Float.valueOf(value / norm);
            object.put(k, f);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer$Analizer;", "", "(Ljava/lang/String;I)V", "WORD", "CHAR", "CHAR_WB", "mlapi-core"})
    public static final class Analizer
    extends Enum<Analizer> {
        public static final /* enum */ Analizer WORD = new Analizer();
        public static final /* enum */ Analizer CHAR = new Analizer();
        public static final /* enum */ Analizer CHAR_WB = new Analizer();
        private static final /* synthetic */ Analizer[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Analizer[] values() {
            return (Analizer[])$VALUES.clone();
        }

        public static Analizer valueOf(String value) {
            return Enum.valueOf(Analizer.class, value);
        }

        @NotNull
        public static EnumEntries<Analizer> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = analizerArray = new Analizer[]{Analizer.WORD, Analizer.CHAR, Analizer.CHAR_WB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/mlapi/feature/preprocessor/TfIdfVectorizer$Companion;", "", "()V", "spacePattern", "Lkotlin/text/Regex;", "tokenPattern", "mlapi-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Analizer.values().length];
            try {
                nArray[Analizer.WORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Analizer.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Analizer.CHAR_WB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

