package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAppDailyDeviceCount invokes the emas_appmonitor.GetAppDailyDeviceCount API synchronously
func (client *Client) GetAppDailyDeviceCount(request *GetAppDailyDeviceCountRequest) (response *GetAppDailyDeviceCountResponse, err error) {
	response = CreateGetAppDailyDeviceCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetAppDailyDeviceCountWithChan invokes the emas_appmonitor.GetAppDailyDeviceCount API asynchronously
func (client *Client) GetAppDailyDeviceCountWithChan(request *GetAppDailyDeviceCountRequest) (<-chan *GetAppDailyDeviceCountResponse, <-chan error) {
	responseChan := make(chan *GetAppDailyDeviceCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAppDailyDeviceCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAppDailyDeviceCountWithCallback invokes the emas_appmonitor.GetAppDailyDeviceCount API asynchronously
func (client *Client) GetAppDailyDeviceCountWithCallback(request *GetAppDailyDeviceCountRequest, callback func(response *GetAppDailyDeviceCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAppDailyDeviceCountResponse
		var err error
		defer close(result)
		response, err = client.GetAppDailyDeviceCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAppDailyDeviceCountRequest is the request struct for api GetAppDailyDeviceCount
type GetAppDailyDeviceCountRequest struct {
	*requests.RpcRequest
	UniqueAppId string           `position:"Body" name:"UniqueAppId"`
	FromDateMs  requests.Integer `position:"Body" name:"FromDateMs"`
	Service     string           `position:"Body" name:"Service"`
	UntilDateMs requests.Integer `position:"Body" name:"UntilDateMs"`
}

// GetAppDailyDeviceCountResponse is the response struct for api GetAppDailyDeviceCount
type GetAppDailyDeviceCountResponse struct {
	*responses.BaseResponse
	RequestId       string            `json:"RequestId" xml:"RequestId"`
	DeviceCountList []DeviceCountItem `json:"DeviceCountList" xml:"DeviceCountList"`
}

// CreateGetAppDailyDeviceCountRequest creates a request to invoke GetAppDailyDeviceCount API
func CreateGetAppDailyDeviceCountRequest() (request *GetAppDailyDeviceCountRequest) {
	request = &GetAppDailyDeviceCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "GetAppDailyDeviceCount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAppDailyDeviceCountResponse creates a response to parse from GetAppDailyDeviceCount response
func CreateGetAppDailyDeviceCountResponse() (response *GetAppDailyDeviceCountResponse) {
	response = &GetAppDailyDeviceCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
