package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListForwardingRules invokes the ga.ListForwardingRules API synchronously
func (client *Client) ListForwardingRules(request *ListForwardingRulesRequest) (response *ListForwardingRulesResponse, err error) {
	response = CreateListForwardingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListForwardingRulesWithChan invokes the ga.ListForwardingRules API asynchronously
func (client *Client) ListForwardingRulesWithChan(request *ListForwardingRulesRequest) (<-chan *ListForwardingRulesResponse, <-chan error) {
	responseChan := make(chan *ListForwardingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListForwardingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListForwardingRulesWithCallback invokes the ga.ListForwardingRules API asynchronously
func (client *Client) ListForwardingRulesWithCallback(request *ListForwardingRulesRequest, callback func(response *ListForwardingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListForwardingRulesResponse
		var err error
		defer close(result)
		response, err = client.ListForwardingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListForwardingRulesRequest is the request struct for api ListForwardingRules
type ListForwardingRulesRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	ListenerId       string           `position:"Query" name:"ListenerId"`
	ForwardingRuleId string           `position:"Query" name:"ForwardingRuleId"`
	NextToken        string           `position:"Query" name:"NextToken"`
	MaxResults       requests.Integer `position:"Query" name:"MaxResults"`
	AcceleratorId    string           `position:"Query" name:"AcceleratorId"`
}

// ListForwardingRulesResponse is the response struct for api ListForwardingRules
type ListForwardingRulesResponse struct {
	*responses.BaseResponse
	TotalCount      int                   `json:"TotalCount" xml:"TotalCount"`
	NextToken       string                `json:"NextToken" xml:"NextToken"`
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	MaxResults      int                   `json:"MaxResults" xml:"MaxResults"`
	ForwardingRules []ForwardingRulesItem `json:"ForwardingRules" xml:"ForwardingRules"`
}

// CreateListForwardingRulesRequest creates a request to invoke ListForwardingRules API
func CreateListForwardingRulesRequest() (request *ListForwardingRulesRequest) {
	request = &ListForwardingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "ListForwardingRules", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListForwardingRulesResponse creates a response to parse from ListForwardingRules response
func CreateListForwardingRulesResponse() (response *ListForwardingRulesResponse) {
	response = &ListForwardingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
