package io.cucumber.cucumberexpressions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeReference<T> {

    private final Type type;

    protected TypeReference() {
        Type superclass = getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new CucumberExpressionException("Missing type parameter: " + superclass);
        }
        this.type = ((ParameterizedType) superclass).getActualTypeArguments()[0];
    }

    public final Type getType() {
        return this.type;
    }
}