// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

chrome.runtime.onMessageExternal.addListener((request, from, sendResponse) => {
  if (request.ping) {
    console.info("Got ping, sending pong...");
    sendResponse({pong: true});
  }
});

/*
What follows is garbage to make the total size of this file more than 64
kilobytes. This is to test the case where the NetworkService has to schedule
multiple tasks to feed this file through a mojo data pipe (when the extension
loads this background.js file resource).

See http://crbug.com/924416 for further details.


|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| _       _                                                                  |
|( )  _  ( )                                         _                       |
|| | ( ) | |   __      _ _    _ __   _     ___ ___  (_)  ___    __           |
|| | | | | | /'__`\   ( '_`\ ( '__)/'_`\ /' _ ` _ `\| |/',__) /'__`\         |
|| (_/ \_) |(  ___/   | (_) )| |  ( (_) )| ( ) ( ) || |\__, \(  ___/         |
|`\___x___/'`\____)   | ,__/'(_)  `\___/'(_) (_) (_)(_)(____/`\____)         |
|                     | |                                                    |
|                     (_)                                                    |
| _                    _                                                     |
|( )_                 ( )_                                                   |
|| ,_)   _        ___ | ,_)   _    _ _                                       |
|| |   /'_`\    /',__)| |   /'_`\ ( '_`\                                     |
|| |_ ( (_) )   \__, \| |_ ( (_) )| (_) )                                    |
|`\__)`\___/'   (____/`\__)`\___/'| ,__/'                                    |
|                                 | |                                        |
|                                 (_)                                        |
|                     _                        ___      _        _           |
|                  _ ( )_  _                  (  _`\   ( )      ( )          |
| _   _   _  _ __ (_)| ,_)(_)  ___     __     | ( (_)__| |__  __| |__        |
|( ) ( ) ( )( '__)| || |  | |/' _ `\ /'_ `\   | |  _(__   __)(__   __)       |
|| \_/ \_/ || |   | || |_ | || ( ) |( (_) |   | (_( )  | |      | |          |
|`\___x___/'(_)   (_)`\__)(_)(_) (_)`\__  |   (____/'  (_)      (_)          |
|                                   ( )_) |                                  |
|                                    \___/'                                  |
| _       _                _____                                             |
|(_ )  _ ( )              (___  )                                            |
| | | (_)| |/')    __         | |   _ _  _   _    _ _                        |
| | | | || , <   /'__`\    _  | | /'_` )( ) ( ) /'_` )                       |
| | | | || |\`\ (  ___/   ( )_| |( (_| || \_/ |( (_| | _                     |
|(___)(_)(_) (_)`\____)   `\___/'`\__,_)`\___/'`\__,_)(_)                    |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
*/
